<?php

namespace App\Modules\Base;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\StrHelper;
use Illuminate\Support\Facades\View;

trait ActivityBaseTrait
{
    protected $activity = false;

    protected function settingSetUp()
    {
        if (false === $this->activity) {
            $this->activity = ModelHelper::load('module_' . StrHelper::uncamelize(self::MODULE) . '_activity', ['alias' => $this->alias]);
        }
        if (empty($this->activity)) {
            header('Location: /');
            exit();
        }
        View::share('_activity', $this->activity);
        View::share('_base', '/m/' . StrHelper::uncamelize(self::MODULE) . '_' . $this->activity['alias']);
    }

    protected function _view($view, $viewData = [])
    {
        $mobileView = 'res::' . self::MODULE . '.' . $this->activity['template'] . '.mobile.' . $view;
        return view($mobileView, $viewData);
    }

    public function _viewRender($view, $viewData)
    {
        $mobileView = 'res::' . self::MODULE . '.' . $this->activity['template'] . '.mobile.' . $view;
        return View::make($mobileView, $viewData)->render();
    }
}