<?php

namespace App\Modules\Base;


use Edwin404\Base\Support\RequestHelper;
use Edwin404\Member\Support\MemberTrait;
use Edwin404\Oauth\Types\OauthType;
use Edwin404\User\Support\UserTrait;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;

class BaseMobileController extends Controller
{
    use MemberTrait;

    protected $alias = null;
    // 注意这个一直是0 主要是为了适配
    protected $memberUserId = 0;
    // $this->memberUserId(),$this->userId() -> 这个是用户的ID
    // $this->memberUser() -> 这个是用户的信息

    public function __construct()
    {
        $this->alias = Request::route('alias');
        if ($memberUser = Session::get('_memberUser')) {
            $memberUser['alias'] = '0';
            Session::set('_memberUser', $memberUser);
        }
        $this->memberUserSetup();
        if (method_exists($this, 'settingSetUp')) {
            $this->settingSetUp();
        }
    }

    protected function getUserLoginUrl($memberUserId)
    {
        return '/m/user_oauth_login_' . $memberUserId . '_' . OauthType::WECHAT_MOBILE
            . '?redirect=' . urlencode(RequestHelper::currentPageUrl());
    }

    protected function userId()
    {
        return $this->memberUserId();
    }

}