<?php

namespace App\Modules\Base;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\StrHelper;
use Illuminate\Support\Facades\View;

trait UserBaseTrait
{
    protected function settingSetUp()
    {
        if (empty($this->memberUser)) {
            header('Location: /');
            exit();
        }
        View::share('_base', '/m/' . StrHelper::uncamelize(self::MODULE) . '_' . $this->memberUser['alias']);
    }

    protected function _view($view, $viewData = [])
    {
        $mobileView = 'res::' . self::MODULE . '.default.mobile.' . $view;
        return view($mobileView, $viewData);
    }

    public function _viewRender($view, $viewData)
    {
        $mobileView = 'res::' . self::MODULE . '.default.mobile.' . $view;
        return View::make($mobileView, $viewData)->render();
    }
}