<?php

namespace App\Modules\PrizePool\Mobile;


use App\Modules\Base\BaseMobileController;
use App\Modules\Base\UserBaseTrait;
use App\Modules\PrizePool\ActivityType;
use App\Modules\PrizePool\DrawnPhysicalStatus;
use App\Modules\User\Types\UserMoneyCashStatus;
use App\Services\PlatformService;
use App\Services\UserService;
use App\Types\UserPayBiz;
use App\Types\UserPayType;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\LockHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Base\Support\StrHelper;
use Edwin404\Base\Support\TypeHelper;
use Edwin404\User\Support\UserLoginCheck;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\View;

class HomeController extends BaseMobileController implements UserLoginCheck
{
    use UserBaseTrait;
    const MODULE = 'prizePool';

    public static function owner()
    {
        $alias = Request::route('alias');
        if (empty($alias)) {
            return 0;
        }
        $memberUser = ModelHelper::loadWithCache('member_user', ['alias' => $alias]);
        if (empty($memberUser)) {
            return 0;
        }
        return $memberUser['id'];
    }

    public function activity($alias, $activityType, $activityAlias)
    {
        $activityName = TypeHelper::name(ActivityType::class, $activityType);
        if (empty($activityName)) {
            return Response::send(-1, '请求错误');
        }
        $table = 'module_' . StrHelper::uncamelize($activityType) . '_activity';
        $activity = ModelHelper::load($table, ['alias' => $activityAlias]);
        if (empty($activity)) {
            return Response::send(-1, '活动不存在');
        }
        if (RequestHelper::isPost()) {
            $page = InputPackage::buildFromInput()->getInteger('page', 1);
            $pageSize = 10;
            $option = [];
            $option['where'] = [
                'userId' => $this->userId(),
                'activityType' => $activityType,
                'activityId' => $activity['id'],
            ];
            $option['order'] = ['id', 'desc'];
            $paginateData = ModelHelper::modelPaginate('module_prize_pool_drawn', $page, $pageSize, $option);
            if (empty($paginateData['records'])) {
                return Response::send(0, null, ['html' => null]);
            }
            $html = $this->_viewRender('prizeItems', [
                'records' => $paginateData['records'],
            ]);
            return Response::send(0, null, ['html' => $html]);
        }
        return $this->_view('activity');
    }

    public function users($alias, $activityType, $activityAlias)
    {
        $activityName = TypeHelper::name(ActivityType::class, $activityType);
        if (empty($activityName)) {
            return Response::send(-1, '请求错误');
        }
        $table = 'module_' . StrHelper::uncamelize($activityType) . '_activity';
        $activity = ModelHelper::load($table, ['alias' => $activityAlias]);
        if (empty($activity)) {
            return Response::send(-1, '活动不存在');
        }
        if (RequestHelper::isPost()) {
            $page = InputPackage::buildFromInput()->getInteger('page', 1);
            $pageSize = 10;
            $option = [];
            $option['where'] = [
                'activityType' => $activityType,
                'activityId' => $activity['id'],
            ];
            $option['order'] = ['id', 'desc'];
            $paginateData = ModelHelper::modelPaginate('module_prize_pool_drawn', $page, $pageSize, $option);
            if (empty($paginateData['records'])) {
                return Response::send(0, null, ['html' => null]);
            }
            ModelHelper::modelJoin($paginateData['records'], 'userId', '_user', 'member_user', 'id');
            $html = $this->_viewRender('userItems', [
                'records' => $paginateData['records'],
            ]);
            return Response::send(0, null, ['html' => $html]);
        }
        return $this->_view('users');
    }

    public function fill($alias, $drawnId)
    {
        $drawn = ModelHelper::load('module_prize_pool_drawn', [
            'id' => $drawnId, 'userId' => $this->userId(),
            'memberUserId' => $this->memberUserId,
        ]);
        if (empty($drawn)) {
            return Response::send(-1, '记录不存在');
        }
        if ($drawn['physicalStatus'] != DrawnPhysicalStatus::DRAWN) {
            return Response::send(-1, '状态不正确');
        }
        if (RequestHelper::isPost()) {
            $input = InputPackage::buildFromInput();
            $update = [];
            $update['userName'] = $input->getTrimString('userName');
            $update['userPhone'] = $input->getPhone('userPhone');
            $update['userAddress'] = $input->getTrimString('userAddress');
            if (empty($update['userName'])) {
                return Response::send(-1, '姓名为空');
            }
            if (empty($update['userPhone'])) {
                return Response::send(-1, '手机为空 或 格式不正确');
            }
            if (empty($update['userAddress'])) {
                return Response::send(-1, '地址为空');
            }
            $update['physicalStatus'] = DrawnPhysicalStatus::WAIT_SHIPPING;
            ModelHelper::updateOne('module_prize_pool_drawn', ['id' => $drawnId], $update);
            return Response::send(0, '收件信息填写成功', null, '[back]');
        }
        return $this->_view('fill', [
            'drawn' => $drawn,
        ]);
    }

}