<?php

namespace App\Modules\User\Manage;

use App\Helpers\CmsHtmlHelper;
use App\Http\Controllers\Support\BaseController;
use App\Modules\PrizePool\ActivityType;
use App\Modules\PrizePool\CreditType;
use App\Modules\PrizePool\DrawnPhysicalStatus;
use App\Modules\PrizePool\PrizeType;
use App\Modules\PrizePool\RedbagType;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Base\Support\TypeHelper;
use Edwin404\Member\Services\MemberCreditService;
use Edwin404\Member\Services\MemberMoneyService;
use Edwin404\Member\Services\MemberReportService;
use Edwin404\Member\Services\MemberService;
use Edwin404\Report\ReportService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;

class HomeController extends BaseController
{
    public function info(MemberService $memberService,
                         MemberMoneyService $memberMoneyService,
                         MemberCreditService $memberCreditService,
                         $id)
    {
        $memberUser = $memberService->load($id);
        return $this->_view('module.user.info', [
            'memberUser' => $memberUser,
            'moneyTotal' => $memberMoneyService->getTotal($memberUser['id']),
            'creditTotal' => $memberCreditService->getTotal($memberUser['id']),
        ]);
    }

}