<?php

namespace App\Modules\User\Mobile;


use App\Modules\Base\BaseMobileController;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Member\Services\MemberCreditService;
use Edwin404\Member\Support\MemberLoginCheck;
use Edwin404\User\Support\UserLoginCheck;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class CreditController extends BaseMobileController implements MemberLoginCheck
{
    public function index(MemberCreditService $memberCreditService,
                          $alias)
    {
        if (RequestHelper::isPost()) {
            $page = InputPackage::buildFromInput()->getInteger('page', 1);
            $pageSize = 10;
            $option = [];
            $option['where'] = ['memberUserId' => $this->userId()];
            $option['order'] = ['id', 'desc'];
            $paginateData = ModelHelper::modelPaginate('member_credit_log', $page, $pageSize, $option);
            if (empty($paginateData['records'])) {
                return Response::send(0, null, ['html' => null]);
            }
            $html = View::make('res::user.default.mobile.creditLogItem', [
                'records' => $paginateData['records'],
            ])->render();
            return Response::send(0, null, ['html' => $html]);
        }
        $creditTotal = $memberCreditService->getTotal($this->memberUserId());
        return view('res::user.default.mobile.credit', [
            'creditTotal' => $creditTotal,
        ]);
    }

}