<?php

namespace App\Modules\User\Mobile;


use App\Modules\Base\BaseMobileController;
use App\Modules\User\Types\UserMoneyCashStatus;
use App\Services\PlatformService;
use App\Services\UserService;
use App\Types\UserPayBiz;
use App\Types\UserPayType;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\LockHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Member\Services\MemberMoneyService;
use Edwin404\Member\Support\MemberLoginCheck;
use Edwin404\User\Support\UserLoginCheck;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\View;

class MoneyController extends BaseMobileController implements MemberLoginCheck
{
    public static function owner()
    {
        $alias = Request::route('alias');
        if (empty($alias)) {
            return 0;
        }
        $memberUser = ModelHelper::loadWithCache('member_user', ['alias' => $alias]);
        if (empty($memberUser)) {
            return 0;
        }
        return $memberUser['id'];
    }

    public function index(MemberMoneyService $memberMoneyService,
                          $alias)
    {
        if (RequestHelper::isPost()) {
            $page = InputPackage::buildFromInput()->getInteger('page', 1);
            $pageSize = 10;
            $option = [];
            $option['where'] = ['memberUserId' => $this->userId()];
            $option['order'] = ['id', 'desc'];
            $paginateData = ModelHelper::modelPaginate('member_money_log', $page, $pageSize, $option);
            if (empty($paginateData['records'])) {
                return Response::send(0, null, ['html' => null]);
            }
            $html = View::make('res::user.default.mobile.moneyLogItem', [
                'records' => $paginateData['records'],
            ])->render();
            return Response::send(0, null, ['html' => $html]);
        }
        $moneyTotal = $memberMoneyService->getTotal($this->memberUserId());
        return view('res::user.default.mobile.money', [
            'moneyTotal' => $moneyTotal,
        ]);
    }

    public function cash(MemberMoneyService $memberMoneyService,
                         PlatformService $platformService,
                         $alias)
    {
        $moneyTotal = $memberMoneyService->getTotal($this->memberUserId());
        if (RequestHelper::isPost()) {
            $money = InputPackage::buildFromInput()->getDecimal('money');
//            if ($money < 1.00) {
//                return Response::send(-1, '提现金额不能小于1.00元');
//            }

            if ($moneyTotal < $money) {
                return Response::generate(-1, '余额不足');
            }

            ModelHelper::transactionBegin();
            $ret = $platformService->cashMoneyToUser(
                0,
                $this->memberUserId(),
                $money
            );
            if ($ret['code']) {
                ModelHelper::transactionRollback();
                return Response::send(-1, $ret['msg']);
            }
            ModelHelper::transactionCommit();

            return Response::send(0, '提现申请成功', null, '[reload]');
        }
        return view('res::user.default.mobile.cash', [
            'moneyTotal' => $moneyTotal,
        ]);
    }

}