<?php

namespace App\Modules\User\Mobile;


use Edwin404\Base\Support\Response;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Member\Services\MemberService;
use Edwin404\Member\Types\Gender;
use Edwin404\Oauth\Core\Oauth;
use Edwin404\Tecmz\Helpers\ConfigEnvHelper;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class OauthController extends Controller
{

    private function getOauthConfig($type)
    {
        $config = [];
        $config['CALLBACK'] = action('\App\Modules\User\Mobile\OauthController@callback', ['oauthType' => $type]);
        $config['APP_KEY'] = ConfigEnvHelper::get('oauthWechatMobileAppId');
        $config['APP_SECRET'] = ConfigEnvHelper::get('oauthWechatMobileAppSecret');
        $config['PROXY'] = ConfigEnvHelper::get('oauthWechatMobileProxy');
        //$config['AUTHORIZE'] = 'scope=snsapi_base';
        return $config;
    }

    public function login($type)
    {
        $config = $this->getOauthConfig($type);
        if (empty($config)) {
            return Response::send(-1, '授权登录配置错误');
        }

        if ($config['PROXY']) {
            $url = $config['PROXY']
                . '?appid=' . $config['APP_KEY'] . '&scope=snsapi_base&redirect_uri='
                . urlencode($config['CALLBACK']);
        } else {
            $sns = Oauth::getInstance($type, $config);
            $url = $sns->getRequestCodeURL();
        }

        $redirect = Input::get('redirect', '/');
        if (!empty($redirect)) {
            Session::put('oauthRedirect', $redirect);
        }

        return redirect($url);
    }

    public function callback(MemberService $memberService, $oauthType)
    {
        $code = Input::get('code', '');
        if (empty($code)) {
            return Response::send(-1, '登录失败(code为空)');
        }

        $config = $this->getOauthConfig($oauthType);
        if (empty($config)) {
            return Response::send(-1, '授权登录配置错误');
        }

        $oauth = Oauth::getInstance($oauthType, $config);
        $token = null;
        $openid = null;
        try {
            $token = $oauth->getAccessToken($code, null);
            $openid = $oauth->openid();
        } catch (\Exception $e) {
            return Response::send(-1, '登录失败(' . $e->getMessage() . ')');
        }

        if (empty($token) || empty($openid)) {
            return Response::send(-1, '登录失败(token=' . print_r($token, true) . ',openid=' . $openid . ')');
        }

        $data = $oauth->call('sns/userinfo');
        if (!empty($data ['errcode'])) {
            return Response::send(-1, "微信登录失败：" . $data['errmsg']);
        }
        $userInfo = [];
        $userInfo['username'] = $data['nickname'];
        $userInfo['avatar'] = $data['headimgurl'];
        if ($data['sex'] == 2) {
            $userInfo['gender'] = Gender::FEMALE;
        } else if ($data['sex'] == 1) {
            $userInfo['gender'] = Gender::MALE;
        } else {
            $userInfo['gender'] = Gender::UNKNOWN;
        }
        $userInfo['province'] = $data['province'];
        $userInfo['city'] = $data['city'];
        $userInfo['country'] = $data['country'];

        $memberUserId = $memberService->getMemberUserIdByOauth($oauthType, $openid);
        if (empty($memberUserId)) {
            $memberUser = $memberService->add($userInfo);
            $memberUserId = $memberUser['id'];
        } else {
            $memberService->update($memberUserId, $userInfo);
        }
        $memberService->putOauth($memberUserId, $oauthType, $openid);
        Session::put('memberUserId', $memberUserId);
        return redirect(Session::get('oauthRedirect', '/'));

    }

}