<?php

namespace App\Providers;

use App\Listeners\MemberListener;
use App\Listeners\PayListener;
use App\Listeners\WechatKeywordListener;
use App\Listeners\WechatMenuListener;
use App\Listeners\WechatSubscribeListener;
use App\Services\PlatformService;
use Edwin404\Common\Support\BladeEnhanceTrait;
use Edwin404\Tecmz\Traits\AssetsCDNTrait;
use Edwin404\Tecmz\Traits\PayConfigTrait;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    use AssetsCDNTrait;
    use PayConfigTrait;
    use BladeEnhanceTrait;

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(Dispatcher $events)
    {
        $this->bootAssetsCDN();
        $this->bootPayConfig();
        $this->bootBladeEnhance();

        $events->subscribe(PayListener::class);

        $this->loadViewsFrom(__DIR__ . '/../../public/res/', 'res');

    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('platformService', PlatformService::class);
    }
}
