<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateModuleScratch extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('member_user', function (Blueprint $table) {
            $table->tinyInteger('moduleScratch')->nullable()->comment('');
            $table->timestamp('moduleScratchExpire')->nullable()->comment('');
        });

        Schema::create('module_scratch_activity', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户ID');

            $table->string('alias', 8)->nullable()->comment('Hash');
            $table->tinyInteger('enable')->nullable()->comment('开启');
            $table->string('template', 20)->nullable()->comment('模板');
            $table->string('title', 200)->nullable()->comment('名称');
            $table->string('description', 1000)->nullable()->comment('活动名描述');
            $table->string('background', 100)->nullable()->comment('背景图');

            $table->timestamp('startTime')->nullable()->comment('开始时间');
            $table->timestamp('endTime')->nullable()->comment('结束时间');

            /** @see \App\Modules\Activity\JoinMode */
            $table->tinyInteger('joinMode')->nullable()->comment('参与模式');
            $table->integer('joinDailyLimit')->nullable()->comment('');

            $table->tinyInteger('shareEnable')->nullable()->comment('分享开启');
            $table->string('shareImage', 200)->nullable()->comment('分享图标');
            $table->string('shareTitle', 200)->nullable()->comment('分享分享标题');
            $table->string('shareDesc', 400)->nullable()->comment('分享描述');

            $table->tinyInteger('prizeUsersEnable')->nullable()->comment('开启已中奖用户列表');
            $table->string('textColor', 10)->nullable()->comment('文字颜色');
            $table->string('backgroundMusic', 100)->nullable()->comment('背景音乐');

            $table->unique('alias');
            $table->index('memberUserId');

        });

        Schema::create('module_scratch_drawn', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('activityId')->nullable()->comment('活动ID');
            $table->integer('userId')->nullable()->comment('用户ID');

            $table->index(['activityId', 'userId']);
            $table->index(['userId']);

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
