@extends('theme.default.pc.member.frame')

@section('pageTitleMain',htmlspecialchars($activity['title']))

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li><a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}">{{MODULE_ACTIVITY_TEXT}}</a></li>
        <li class="uk-active"><span>{{$activity['title']}}</span></li>
    </ul>
@endsection

@section('bodyScript')
    @parent
    <script src="@assets('assets/echarts/echarts.all.js')"></script>
    <script>
        $(function () {
            var option = {
                color: ['#DF6B25'],
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {
                        type : 'shadow'
                    }
                },
                grid: {
                    left: '3%',
                    right: '3%',
                    bottom: '3%',
                    top:'3%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : @jsonArray($drawLatestReport['time']),
                        axisTick: {
                            alignWithLabel: true,
                        },
                        axisLabel:{
                            interval:0,
                            formatter: function (value, index) {
                                var date = new Date(value);
                                return [(date.getMonth()<9?'0':''),(date.getMonth() + 1), (date.getDate()<10?'0':''),date.getDate()].join('');
                            }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value'
                    }
                ],
                series : [
                    {
                        name:'参与人数',
                        type:'bar',
                        barWidth: '60%',
                        data:@jsonArray($drawLatestReport['value'])
                    }
                ]
            };
            echarts.init(document.getElementById('drawLatestReport')).setOption(option);
        });
    </script>
@endsection

@section('memberContent')

    <div class="uk-grid">
        <div class="uk-width-1-2">

            <div class="pb pb-module-panel">
                <div class="head">
                    <div class="more">
                        <a href="javascript:;" data-confirm="删除后所有数据将会被清空不可恢复，确定删除?" data-ajax-request-loading data-ajax-request="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_activity_delete/{{$activity['id']}}" class="uk-text-muted">
                            <i class="uk-icon-trash"></i>
                        </a>
                    </div>
                    <h2>{{$activity['title']}}</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_drawn/{{$activity['id']}}" class="item-count">
                                <i class="uk-icon-users"></i>
                                <span class="value uk-text-success">{{number_format(\Edwin404\Base\Support\ModelHelper::count('module_'.MODULE_ACTIVITY_NAME_UNDERSCORE.'_drawn',['activityId'=>$activity['id']]))}}</span>
                                <span class="title">参与人次</span>
                            </a>
                        </div>
                        <div class="uk-width-1-2">
                            <a href="/module/manage/prize_pool_drawn<?php echo htmlspecialchars('#{"page":1,"field":[],"order":[],"search":[{"activityType":{"equal":"'.MODULE_ACTIVITY_NAME.'"}},{"activityId":{"equal":"'.$activity['id'].'"}}]}'); ?>" class="item-count">
                                <i class="uk-icon-gift"></i>
                                <span class="value uk-text-success">{{number_format(\Edwin404\Base\Support\ModelHelper::count('module_prize_pool_drawn',['activityType'=>MODULE_ACTIVITY_NAME,'activityId'=>$activity['id']]))}}</span>
                                <span class="title">抽中奖人次</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>


            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>操作</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_drawn/{{$activity['id']}}" class="item">
                                <i class="uk-icon-list"></i>
                                <span>参与抽奖记录</span>
                            </a>
                        </div>
                        <div class="uk-width-1-2">
                            <a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_activity_edit/{{$activity['id']}}" class="item">
                                <i class="uk-icon-cog"></i>
                                <span>活动设置</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="uk-width-1-2">

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>抽奖参与人数</h2>
                </div>
                <div class="body">
                    <div id="drawLatestReport" style="height:235px;width:100%;"></div>
                </div>
            </div>

        </div>
    </div>

    @include('theme.default.pc.module.linkPanel',[
        'linkTitle'=>'链接',
        'linkUrl'=>action('\App\Modules\\'.ucfirst(MODULE_ACTIVITY_NAME).'\Mobile\HomeController@home',['alias'=>$activity['alias']]),
    ])

@endsection