@extends('theme.default.pc.member.frame')

@section('pageTitleMain','活动编辑')

@section('headScript')
    <link rel="stylesheet" href="@assets('assets/vue/iview/iview.css')">
    @parent
    <script src="@assets('assets/vue/vue.js')"></script>
    <script src="@assets('assets/vue/iview/iview.js')"></script>
@endsection

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li><a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}">{{MODULE_ACTIVITY_TEXT}}</a></li>
        <li class="uk-active"><span>活动编辑</span></li>
    </ul>
@endsection

@section('bodyScript')
    @parent
    <script>
        $(function () {
            var app = null;
            var data = {
                activityDescriptionExample:false,
                activity:{
                    title:@jsonString($activity['title']),
                    enable:@jsonBoolean($activity['enable']),
                    startTime:@jsonDatetime($activity['startTime']),
                    endTime:@jsonDatetime($activity['endTime']),
                    description:@jsonString($activity['description']),

                    joinMode:@jsonNumber($activity['joinMode']),
                    joinDailyLimit:@jsonNumber($activity['joinDailyLimit']),

                    background:@jsonString($activity['background']),
                    prizeUsersEnable:@jsonBoolean($activity['prizeUsersEnable']),
                    textColor:@jsonString($activity['textColor'],'#EEEEEE'),
                    backgroundMusic:@jsonString($activity['backgroundMusic']),

                    shareEnable:@jsonBoolean($activity['shareEnable']),
                    shareImage:@jsonString($activity['shareImage']),
                    shareTitle:@jsonString($activity['shareTitle']),
                    shareDesc:@jsonString($activity['shareDesc']),
                },
                prizes:@jsonArray($prizes)
            };
            var init = function () {
                $('[data-background-box]').on('image-template-widget.change',function (event,value) {
                    if(app){
                        app.activity.background = value;
                    }
                }).imageTemplateWidget().val(data.activity.background);
                $('[data-share-image-box]').on('image-widget.change',function (event,value) {
                    if(app){
                        app.activity.shareImage = value;
                    }
                }).imageWidget().val(data.activity.shareImage);
                $('[data-audio-selector-value="backgroundMusic"]').on('audio-selector-value.change',function(event,value){
                    if(app){
                        app.activity.backgroundMusic = value;
                    }
                });
            };
            var methods = {
                viewPrize:function (id) {
                    window.api.dialog.dialog('/module/manage/prize_pool_prize_view/'+id);
                },
                deletePrize:function (index) {
                    this.prizes.splice(index,1);
                },
                addPrize:function () {
                    new window.api.commonSelectDialog({
                        server:'/module/manage/prize_pool_prize_dialog',
                        callback:function (items) {
                            for(var i=0;i<items.length;i++){
                                if(app.prizes.length>= {{MODULE_ACTIVITY_MAX_PRIZE}} ){
                                    window.api.dialog.tipError('最多使用'+ {{MODULE_ACTIVITY_MAX_PRIZE}} +'个奖品')
                                    break;
                                }
                                app.prizes.push({
                                    prizeId:items[i].id,
                                    prizeTitle:items[i].name,
                                    rate:0,
                                    amountType:{{\App\Modules\PrizePool\AmountType::NO_LIMITED}},
                                    amount:0
                                });
                            }
                        }
                    }).show();
                },
                save:function () {
                    window.api.dialog.loadingOn();
                    var data = $.extend({},this.$data);
                    $.post('?',{data:JSON.stringify(data)},function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    });
                }
            };
            app = new Vue({
                el: '#app',
                data:data,
                methods:methods,
                mounted:function () {
                    setTimeout(function () {
                        init();
                    },100);
                }
            });
        });
    </script>
@endsection

@section('memberContent')
    <div id="app" v-cloak>

        <div class="pb pb-module-panel">
            <div class="head">
                <h2>基本信息</h2>
            </div>
            <div class="body">
                <i-form :label-width="100">
                    <Form-item label="名称">
                        <i-input v-model="activity.title"></i-input>
                    </Form-item>
                    <Form-item label="启用">
                        <i-switch v-model="activity.enable"></i-switch>
                    </Form-item>
                    <Form-item label="活动时间">
                        <Row>
                            <i-col span="4">
                                <Date-picker class="uk-width-1-1" type="datetime" v-model="activity.startTime"></Date-picker>
                            </i-col>
                            <i-col span="1" style="text-align:center">-</i-col>
                            <i-col span="4">
                                <Date-picker class="uk-width-1-1" type="datetime" v-model="activity.endTime"></Date-picker>
                            </i-col>
                        </Row>
                    </Form-item>
                    <Form-item label="活动描述">
                        <i-input v-model="activity.description" type="textarea" :autosize="{minRows:2}"></i-input>
                        <a href="javascript:;" @click="activityDescriptionExample=true">活动说明示例</a>
                        <Modal v-model="activityDescriptionExample" title="活动说明示例">
                            1、活动时间：****年**月**日至****年**月**日；<br />
                            2、每人可获得1次抽奖机会；<br />
                            3、对于不符参与规则的中奖客户，将取消领奖资格而不另行通知；<br />
                            4、若因漏填或错填信息，造成奖品无法发放，主办方不负相关责任；<br />
                            5、本活动最终解释权归*****所有。
                        </Modal>
                    </Form-item>
                    <Form-item label="参与限制">
                        <Radio-group v-model="activity.joinMode">
                            @foreach(\App\Modules\Activity\JoinMode::getList() as $k=>$v)
                                <Radio label="{{$k}}">{{$v}}</Radio>
                            @endforeach
                        </Radio-group>
                    </Form-item>
                    <Form-item label="每日限制" v-show="activity.joinMode=={{\App\Modules\Activity\JoinMode::LIMIT_DAILY}}">
                        <i-input v-model="activity.joinDailyLimit"></i-input>
                    </Form-item>
                </i-form>
            </div>
        </div>

        <div class="pb pb-module-panel">
            <div class="head">
                <h2>界面样式</h2>
            </div>
            <div class="body">
                <i-form :label-width="100">
                    <Form-item label="背景图">
                        <div data-image-template-widget data-background-box>
                            <div class="list">
                                @foreach($defaultBackgrounds as $background)
                                    <div class="item" data-value="{{$background['image']}}">
                                        <div class="image" style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['image'])}});"></div>
                                        <div class="text">{{$background['title']}}</div>
                                    </div>
                                @endforeach
                                <div class="item custom">
                                    <div class="image">
                                        <i class="uk-icon-edit"></i>
                                    </div>
                                    <div class="text">自定义</div>
                                </div>
                            </div>
                            <input type="hidden" name="background" data-image value="" />
                        </div>
                        <div>
                            您也可以下载 <a href="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix('res/'.MODULE_ACTIVITY_NAME.'/default/mobile/defaultBackground.jpg')}}" target="_blank">模板背景图片</a> 自行设计上传
                        </div>
                    </Form-item>
                    <Form-item label="显示中奖用户">
                        <i-switch v-model="activity.prizeUsersEnable"></i-switch>
                    </Form-item>
                    <Form-item label="底部文字颜色">
                        <color-picker v-model="activity.textColor" />
                    </Form-item>
                    <Form-item label="背景音乐" class="uk-form">
                        <input data-audio-selector-value="backgroundMusic" v-model="activity.backgroundMusic" type="text" value="{{$activity['musicUrl'] or ''}}" class="uk-form-control uk-width-2-3" placeholder="http://" />
                        <a href="javascript:;" class="uk-button" data-audio-selector="backgroundMusic">选择</a>
                    </Form-item>
                </i-form>
            </div>
        </div>

        <div class="pb pb-module-panel">
            <div class="head">
                <h2>分享设置</h2>
            </div>
            <div class="body">
                <i-form :label-width="80">
                    <Form-item label="允许分享">
                        <i-switch v-model="activity.shareEnable"></i-switch>
                    </Form-item>
                    <Form-item label="分享图标" v-show="!!activity.shareEnable">
                        <div data-image-widget data-share-image-box>
                            <input type="hidden" name="shareImage" data-image value="assets/lib/img/none.png" />
                            <span class="image" style="background-image:url(@assets('assets/lib/img/none.png'));"></span>
                            <span class="add"><i class="uk-icon-plus"></i></span>
                            <span class="delete"><i class="uk-icon-remove"></i></span>
                        </div>
                    </Form-item>
                    <Form-item label="分享标题" v-show="!!activity.shareEnable">
                        <i-input v-model="activity.shareTitle"></i-input>
                    </Form-item>
                    <Form-item label="分享描述" v-show="!!activity.shareEnable">
                        <i-input v-model="activity.shareDesc" type="textarea" :autosize="{minRows:2}"></i-input>
                    </Form-item>
                </i-form>
            </div>
        </div>

        <div class="pb pb-module-panel">
            <div class="head">
                <h2>奖品设置</h2>
            </div>
            <div class="body">
                <div v-for="(prizeItem,prizeItemIndex) in prizes">
                    <i-form :label-width="80">
                        <Row>
                            <i-col span="6">
                                <Form-item :label="'奖品-'+(prizeItemIndex+1)">
                                    <i-button style="max-width:100%;overflow:hidden;text-overflow:ellipsis;" @click="viewPrize(prizeItem.prizeId)">@{{ prizeItem.prizeTitle }}</i-button>
                                </Form-item>
                            </i-col>
                            <i-col span="5">
                                <Form-item label="概率：">
                                    <i-input placeholder="0-100" v-model="prizeItem.rate" style="width:8em;">
                                        <span slot="append">%</span>
                                    </i-input>
                                </Form-item>
                            </i-col>
                            <i-col span="6">
                                <Form-item label="数量：">
                                    <Radio-group v-model="prizeItem.amountType">
                                        @foreach(\App\Modules\PrizePool\AmountType::getList() as $k=>$v)
                                            <Radio label="{{$k}}">{{$v}}</Radio>
                                        @endforeach
                                    </Radio-group>
                                </Form-item>
                            </i-col>
                            <i-col span="5">
                                <Form-item label="限制数量：" v-show="prizeItem.amountType=={{\App\Modules\PrizePool\AmountType::FIXED}}">
                                    <Input-number :max="999999" :min="1" v-model="prizeItem.amount"></Input-number>
                                </Form-item>
                                <div v-show="prizeItem.amountType=={{\App\Modules\PrizePool\AmountType::NO_LIMITED}}">&nbsp;</div>
                            </i-col>
                            <i-col span="2">
                                <a href="javascript:;" @click="deletePrize(prizeItemIndex)" title="删除" data-uk-tooltip style="line-height:30px;"><i class="uk-icon-trash"></i></a>
                            </i-col>
                        </Row>
                    </i-form>
                </div>
                <div class="uk-text-center" v-show="prizes.length < {{MODULE_ACTIVITY_MAX_PRIZE}} ">
                    <a href="javascript:;" @click="addPrize()"><i class="uk-icon-plus"></i> 增加一个奖品</a>
                </div>
            </div>
        </div>

        <div style="height:70px;"></div>
        <div class="pb pb-module-panel pb-module-panel-bottom-fixed">
            <div class="body">
                <button id="save" class="uk-button uk-button-primary uk-width-1-1" @click="save()">保存</button>
            </div>
        </div>

    </div>

@endsection