@extends('theme.default.pc.dialogFrame')

@section('pageTitle','选择奖品')

@section('headAppend')
    @parent
    <style type="text/css">
        body,html{background:#FFF;}
        #lister .item{cursor:default;}
        #lister .item.disable{background:#EEE;color:#999;cursor:not-allowed;}
        #lister .item .checked{color:#CCC;font-size:16px;line-height:16px;}
        #lister .item.select .checked{display:inline-block;color:red;}
        #lister .item .cover{width:20px;height:20px;border-radius:3px;}
    </style>
@endsection

@section('bodyAppend')
@parent
<script>
    $(function () {
        $('#lister').on('click','.item',function () {
            if($(this).is('.disable')){
                window.api.dialog.tipError('奖品被禁用不能选择');
                return false;
            }
            if($(this).is('.select')){
                $(this).removeClass('select');
            }else{
                $(this).addClass('select');
            }
            return false;
        });
        $('#_frameTool').show().find('.h-submit').show().on('click',function () {
            var prizes = [];
            $('#lister .item.select').each(function (i,o) {
                prizes.push({
                    id:$(o).attr('data-id'),
                    name:$(o).attr('data-name')
                });
            });
            window.parent.__commonSelectDialogItems = prizes;
            window.parent.layer.closeAll();
            return false;
        });
    });
</script>
@endsection

@section('bodyContent')

    <table class="uk-table" id="lister">
        @if(empty($prizes))
            <tbody>
            <tr>
                <td>
                    <div class="uk-text-center" style="padding:40px 0;">
                        暂无奖品，请在 <a href="/module/manage/prize_pool" target="_parent">礼品中心</a> 添加
                    </div>
                </td>
            </tr>
            </tbody>
        @else
            <thead>
                <tr>
                    <th width="20">&nbsp;</th>
                    <th width="50">类型</th>
                    <th>奖品</th>
                    <th width="80">
                        <a href="/module/manage/prize_pool" target="_blank" data-uk-tooltip title="新窗口打开管理奖品"><i class="uk-icon-edit"></i> 管理奖品</a>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach($prizes as $prize)
                    <tr class=" item @if(!$prize['enable']) disable @endif" data-id="{{$prize['id']}}" data-name="{{$prize['name']}}">
                        <td>
                            <i class="checked uk-icon-check-circle"></i>
                        </td>
                        <td>
                            @if($prize['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                                <span class="uk-badge uk-badge-notification uk-badge-danger">红包</span>
                            @endif
                            @if($prize['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                                <span class="uk-badge uk-badge-notification uk-badge-success">积分</span>
                            @endif
                            @if($prize['type']==\App\Modules\PrizePool\PrizeType::CODE)
                                <span class="uk-badge uk-badge-notification uk-badge-warning">兑换码</span>
                            @endif
                            @if($prize['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                                <span class="uk-badge uk-badge-notification uk-badge-primary">实物</span>
                            @endif
                        </td>
                        <td>
                            {{$prize['name']}}
                        </td>
                        <td>
                            @if($prize['enable'])
                                <span class="uk-badge uk-badge-success">正常</span>
                            @else
                                <span class="uk-badge uk-badge-danger">禁用</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        @endif
    </table>

@endsection
