@extends('theme.default.pc.dialogFrame')

@section('pageTitle',htmlspecialchars($prize['name']))

@section('bodyContent')

    <table class="uk-table">
        <tbody>
            <tr>
                <td width="60">状态：</td>
                <td>
                    @if($prize['enable'])
                        <span class="uk-badge uk-badge-success">正常</span>
                    @else
                        <span class="uk-badge uk-badge-danger">禁用</span>
                    @endif
                </td>
            </tr>
            @if($prize['cover'])
                <tr>
                    <td>图片：</td>
                    <td>
                        <img style="width:80px;height:80px;" src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($prize['cover'])}}" />
                    </td>
                </tr>
            @endif
            <tr>
                <td>名称：</td>
                <td>{{$prize['name']}}</td>
            </tr>
            <tr>
                <td>类型：</td>
                <td>
                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                        <span class="uk-badge uk-badge-notification uk-badge-danger">红包</span>
                    @endif
                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                        <span class="uk-badge uk-badge-notification uk-badge-success">积分</span>
                    @endif
                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::CODE)
                        <span class="uk-badge uk-badge-notification uk-badge-warning">兑换码</span>
                    @endif
                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                        <span class="uk-badge uk-badge-notification uk-badge-primary">实物</span>
                    @endif
                </td>
            </tr>
            @if($prize['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                <td>&nbsp;</td>
                <td>
                    @if($prize['redbagType']==\App\Modules\PrizePool\RedbagType::FIXED)
                        固定金额 {{$prize['redbagFixed']}}
                    @endif
                    @if($prize['redbagType']==\App\Modules\PrizePool\RedbagType::RANDOM)
                        随机金额 {{$prize['redbagMin']}} - {{$prize['redbagMax']}}
                    @endif
                </td>
            @endif
            @if($prize['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                <td>&nbsp;</td>
                <td>
                    @if($prize['creditType']==\App\Modules\PrizePool\CreditType::FIXED)
                        固定积分 {{$prize['creditFixed']}} 分
                    @endif
                    @if($prize['creditType']==\App\Modules\PrizePool\CreditType::RANDOM)
                        随机积分 {{$prize['creditMin']}} - {{$prize['creditMax']}} 分
                    @endif
                </td>
            @endif
        </tbody>
    </table>

@endsection
