<?php

namespace Edwin404\Base\Support;

use Illuminate\Support\Facades\Request;

class Response
{
    public static function generate($code, $msg, $data = null)
    {
        $response = [
            'code' => $code,
            'msg' => $msg,
            'data' => $data,
        ];
        if (null === $data) {
            unset($response['data']);
        }
        return $response;
    }

    public static function json($code, $msg, $data = null, $redirect = null)
    {
        $response = [
            'code' => $code,
            'msg' => $msg,
            'data' => $data,
            'redirect' => $redirect,
        ];
        if (null === $redirect) {
            unset($response['redirect']);
        }
        return \Illuminate\Support\Facades\Response::json($response);
    }

    public static function send($code, $msg, $data = null, $redirect = null)
    {

        if (Request::ajax()) {
            return self::json($code, $msg, $data, $redirect);
        } else {
            if (empty($msg) && $redirect) {
                return redirect($redirect);
            }
            $response = [
                'code' => $code,
                'msg' => $msg,
                'redirect' => $redirect,
                'data' => $data
            ];
            if (null === $redirect) {
                unset($response['redirect']);
            }
            return view('base::msg', $response);
        }
    }

    /**
     * @deprecated
     */
    public static function schema()
    {
        static $schema = null;
        if (null === $schema) {
            if (Request::secure()) {
                $schema = 'https';
            } else {
                $schema = 'http';
            }
        }
        return $schema;
    }

}