<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  contact                                                                                  #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Contact functions to send and save messages                                              #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  17.02.2007:                                                                              #
#  -----------                                                                              #
#  Divided message listing and settings to diferent tabs                                    #
#                                                                                           #
#############################################################################################

        dbhcms_p_add_string('ext_name', $ext_title);
        dbhcms_p_add_template_ext('ext_content', 'contact.tpl', DBHCMS_C_EXT_CONTACT);

#############################################################################################
#  BE IMPLEMENTATION                                                                        #
#############################################################################################

        $settings_class = 'tab_no';
        $messages_class = 'tab_no';

        if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['contactBePart'])) {
                if ($GLOBALS['DBHCMS']['TEMP']['PARAMS']['contactBePart'] == 'settings') {
                        $settings_class = 'tab_act';
                        include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_CONTACT.'/ext.'.DBHCMS_C_EXT_CONTACT.'.be.conf.php');
                } else {
                        $messages_class = 'tab_act';
                        include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_CONTACT.'/ext.'.DBHCMS_C_EXT_CONTACT.'.be.msg.php');
                }
        } else {
                $messages_class = 'tab_act';
                include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_CONTACT.'/ext.'.DBHCMS_C_EXT_CONTACT.'.be.msg.php');
        }

        $contact_tabs = '       <td>
                                                                <div class="'.$messages_class.'"> 
                                                                        &nbsp;&nbsp; <a href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_CONTACT, 'contactBePart' => 'messages')).'"> '.$GLOBALS['DBHCMS']['DICT']['BE']['messages'].' </a> &nbsp;&nbsp;
                                                                </div>
                                                        </td>
                                                        <td width="5"></td>
                                                        <td>
                                                                <div class="'.$settings_class.'"> 
                                                                        &nbsp;&nbsp; <a href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_CONTACT, 'contactBePart' => 'settings')).'"> '.$GLOBALS['DBHCMS']['DICT']['BE']['settings'].' </a> &nbsp;&nbsp;
                                                                </div>
                                                        </td>
                                                        <td width="5"></td>
                                                        ';

        dbhcms_p_add_string('contactTabs', $contact_tabs);

### EOF ### (C) 2005-2016 Kai S. Bunk #######################################################

?>
