<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  register                                                                                 #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Interface for users to register themselves with e-mail verification and password         #
#  recovery using the e-mail.                                                               #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  13.08.2013:                                                                              #
#  -----------                                                                              #
#  File created                                                                             #
#                                                                                           #
#############################################################################################
# $Id: ext.register.be.php 67 2007-02-19 13:29:52Z kaisven $                                #
#############################################################################################

	dbhcms_p_add_string('ext_name', $ext_title);
	dbhcms_p_add_template_ext('ext_content', 'register.tpl', 'register');

#############################################################################################
#  BE IMPLEMENTATION                                                                        #
#############################################################################################

        $settings_class = 'tab_no';
        $pending_class  = 'tab_no';

        if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerBePart'])) {
                if ($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerBePart'] == 'settings') {
                        $settings_class = 'tab_act';
                        dbhcms_p_add_template_ext('registerContent', 'register.settings.tpl', 'register');
                        include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_REGISTER.'/ext.'.DBHCMS_C_EXT_REGISTER.'.settings.php');
                } else {
                        $pending_class = 'tab_act';
                        dbhcms_p_add_template_ext('registerContent', 'register.pending.tpl', 'register');
                        include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_REGISTER.'/ext.'.DBHCMS_C_EXT_REGISTER.'.pending.php');
                }
        } else {
                $pending_class = 'tab_act';
                dbhcms_p_add_template_ext('registerContent', 'register.pending.tpl', 'register');
                include($GLOBALS['DBHCMS']['CONFIG']['CORE']['extensionDirectory'].DBHCMS_C_EXT_REGISTER.'/ext.'.DBHCMS_C_EXT_REGISTER.'.pending.php');
        }

        $register_tabs = '  <td>
                                                <div class="'.$pending_class.'"> 
                                                        &nbsp;&nbsp; <a href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_REGISTER, 'registerBePart' => 'pending')).'"> '.$GLOBALS['DBHCMS']['DICT']['BE']['users'].' </a> &nbsp;&nbsp;
                                                </div>
                                        </td>
                                        <td width="5"></td>
                                        <td>
                                                <div class="'.$settings_class.'"> 
                                                        &nbsp;&nbsp; <a href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_REGISTER, 'registerBePart' => 'settings')).'"> '.$GLOBALS['DBHCMS']['DICT']['BE']['settings'].' </a> &nbsp;&nbsp;
                                                </div>
                                        </td>
                                        <td width="5"></td>';

        dbhcms_p_add_string('registerTabs', $register_tabs);

### EOF ### (C) 2005-2016 Kai S. Bunk #######################################################

?>