<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  register                                                                                 #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Interface for users to register themselves with e-mail verification and password         #
#  recovery using the e-mail.                                                               #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  13.08.2013:                                                                              #
#  -----------                                                                              #
#  File created                                                                             #
#                                                                                           #
#############################################################################################

#############################################################################################
#  FE IMPLEMENTATION                                                                        #
#############################################################################################

	dbhcms_p_hide_block('registerError');
  dbhcms_p_hide_block('registerSuccessful');
  dbhcms_p_hide_block('registerVerificationSuccessful');
  
  // If comming from the login form, then we use the login data
  if (isset($_POST['registerFromLogin'])) {
    $redirect = $GLOBALS['DBHCMS']['DOMAIN']['absoluteUrl'].dbhcms_f_get_url_from_pid_wp(register_f_get_config_param('registerPage'), array('registerLoginName' => dbhcms_f_input_to_value('dbhcms_user', DBHCMS_C_DT_STRING), 'registerPassword' => dbhcms_f_input_to_value('dbhcms_passwd', DBHCMS_C_DT_STRING)));
    header('Location: '.$redirect);
    die();
  }
  
  //* Storing default information
  if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerLoginName'])) {
    dbhcms_p_add_string('registerLoginName', htmlspecialchars($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerLoginName']));
    if (register_f_get_config_param('requireUserName') == false) {
      dbhcms_p_add_string('registerEmail', htmlspecialchars($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerLoginName']));
    }
  }
  if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerPassword'])) {
    dbhcms_p_add_string('registerPassword', htmlspecialchars($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerPassword']));
  }

  // There is nothing to do if there is a user logged in ...
  if (!$_SESSION['DBHCMSDATA']['AUTH']['authenticated']) {
    
    if (isset($_POST['todo'])) {
      if ($_POST['todo'] == 'register') {
  
        //* Storing information so the user does not have to re-enter it
        dbhcms_p_add_string('registerLoginName',       htmlspecialchars(dbhcms_f_input_to_value('registerLoginName',       DBHCMS_C_DT_STRING)));
        dbhcms_p_add_string('registerName',            htmlspecialchars(dbhcms_f_input_to_value('registerName',            DBHCMS_C_DT_STRING)));
        dbhcms_p_add_string('registerEmail',           htmlspecialchars(dbhcms_f_input_to_value('registerEmail',           DBHCMS_C_DT_STRING)));
        dbhcms_p_add_string('registerPassword',        htmlspecialchars(dbhcms_f_input_to_value('registerPassword',        DBHCMS_C_DT_STRING)));
        dbhcms_p_add_string('registerConfirmPassword', htmlspecialchars(dbhcms_f_input_to_value('registerConfirmPassword', DBHCMS_C_DT_STRING)));

        //* Checking if terms of use where accepted
        if (dbhcms_f_input_to_value('registerAcceptTerms', DBHCMS_C_DT_STRING) == "True") {

            //* Checking captcha if required
            if ((register_f_get_config_param('requireCaptcha') == false) || ((isset($_SESSION['DBHCMSDATA']['TEMP']['registerCaptchaNumber']))&&(isset($_POST['registerCaptcha']))&&($_SESSION['DBHCMSDATA']['TEMP']['registerCaptchaNumber'] == dbhcms_f_input_to_value('registerCaptcha', DBHCMS_C_DT_INTEGER)))) {

                //* Checking if there allready is a user with this e-mail or username
                $user_exists = false;
                $users = mysql_query("SELECT user_login, user_email FROM ".dbhcms_f_table_name(DBHCMS_C_TBL_USERS));
                while ($row = mysql_fetch_array($users)) {
                  if ((strcasecmp($row['user_login'], dbhcms_f_input_to_value('registerLoginName', DBHCMS_C_DT_STRING)) == 0) || (strcasecmp($row['user_email'], dbhcms_f_input_to_value('registerEmail', DBHCMS_C_DT_STRING)) == 0)) {
                    $user_exists = true;
                    break;
                  }
                }
                //* Checking if there allready is a user registered with this
                //* e-mail or username but has not yet validated it
                if ($user_exists == false) {
                    $users = mysql_query("SELECT rgpd_login_name, rgpd_email FROM ".dbhcms_f_table_name("ext_register_pending"));
                    while ($row = mysql_fetch_array($users)) {
                      if ((strcasecmp($row['rgpd_login_name'], dbhcms_f_input_to_value('registerLoginName', DBHCMS_C_DT_STRING)) == 0) || (strcasecmp($row['rgpd_email'], dbhcms_f_input_to_value('registerEmail', DBHCMS_C_DT_STRING)) == 0)) {
                        $user_exists = true;
                        break;
                      }
                    }
                }

                //* If the user does not exists
                if ($user_exists == false) {

                  //* Checking that passwords match
                  if ((register_f_get_config_param('requirePasswordConfirmation') == false) || (strcasecmp(dbhcms_f_input_to_value('registerPassword', DBHCMS_C_DT_STRING), dbhcms_f_input_to_value('registerConfirmPassword', DBHCMS_C_DT_STRING)) == 0)) {

                    if (register_f_get_config_param('requireUserName') == false) {
                      $UserLoginName =dbhcms_f_input_to_dbvalue('registerEmail', DBHCMS_C_DT_STRING);
                    } else {
                      $UserLoginName = dbhcms_f_input_to_dbvalue('registerLoginName', DBHCMS_C_DT_STRING);
                    }

                    //* If confirmation is required by e-mail ...
                    if (register_f_get_config_param('validateEmail') == true) {

                        //* Generating confirmation e-mail
                        $email_confirmatuin_url = $GLOBALS['DBHCMS']['DOMAIN']['absoluteUrl'].dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('registerMailConfirmation' => dbhcms_f_input_to_value('registerEmail', DBHCMS_C_DT_STRING)));

                        //* Storing registration in pending table
                        mysql_query (  "INSERT INTO
                                            ".dbhcms_f_table_name("ext_register_pending")."
                                                (
                                                    rgpd_login_name,
                                                    rgpd_real_name,
                                                    rgpd_email,
                                                    rgpd_password,
                                                    rgpd_email_confirmation_url
                                                )
                                        VALUES
                                                (
                                                    '".$UserLoginName."',
                                                    '".dbhcms_f_input_to_dbvalue('registerName',     DBHCMS_C_DT_STRING)."',
                                                    '".dbhcms_f_input_to_dbvalue('registerEmail',    DBHCMS_C_DT_STRING)."',
                                                    '".dbhcms_f_input_to_dbvalue('registerPassword', DBHCMS_C_DT_PASSWORD)."',
                                                    '".dbhcms_f_value_to_dbvalue($email_confirmatuin_url, DBHCMS_C_DT_STRING)."'
                                                );"

                                    );

                        //* Sending confirmation e-mail
                        register_p_send_email_confirmation_message( dbhcms_f_input_to_value('registerEmail', DBHCMS_C_DT_STRING),
                                                                    $email_confirmatuin_url,
                                                                    dbhcms_f_input_to_value('registerName', DBHCMS_C_DT_STRING),
                                                                    $UserLoginName
                                                                  );

                    } else {
                      //* No e-mail validation required. creating user
                      register_p_add_user( $UserLoginName,
                                           dbhcms_f_input_to_value($row['registerEmail'],     DBHCMS_C_DT_STRING),
                                           dbhcms_f_input_to_value($row['registerName'],      DBHCMS_C_DT_STRING),
                                           dbhcms_f_input_to_value($row['registerPassword'],  DBHCMS_C_DT_PASSWORD)
                                         );
                    }

                    //* Showing successfull message
                    dbhcms_p_add_block('registerSuccessful', array('registerMessage')); # show successful response message
                    dbhcms_p_add_block_values('registerSuccessful', array('Thank you for registering!'));
                    //* Hiding registration block
                    dbhcms_p_hide_block('registerForm');

                  } else {
                    //* Passwords do not match
                    dbhcms_p_add_block('registerError', array('registerMessage')); # show response message
                    dbhcms_p_add_block_values('registerError', array('Passwords do not match.'));
                  }

                } else {
                  //* The user allready exists
                  dbhcms_p_add_block('registerError', array('registerMessage')); # show response message
                  dbhcms_p_add_block_values('registerError', array('The user or e-mail already exists. Perhaps you have already registered, if not, try again.'));
                }

            } else {
              # Show wrong captcha error
              dbhcms_p_add_block('registerError', array('registerMessage')); # show response message
              dbhcms_p_add_block_values('registerError', array(dbhcms_f_dict('wrongcaptcha')));
            }

        } else {
          # Terms nos accepted
          dbhcms_p_add_block('registerError', array('registerMessage')); # show response message
          dbhcms_p_add_block_values('registerError', array('You must accept the terms of use to register.'));
        }
  		}
  	} else {
  	    
        //* If password verificaction is in requested
        if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerMailConfirmation'])) {
  
          //* Searching for the corresponding pending registration
          $users = mysql_query("SELECT rgpd_login_name, rgpd_email, rgpd_real_name, rgpd_password FROM ".dbhcms_f_table_name("ext_register_pending"));
          while ($row = mysql_fetch_array($users)) {
            echo "Found dat ain database. ".$row['rgpd_email']." - ".$GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerMailConfirmation'];
            if (strcasecmp($row['rgpd_email'], $GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerMailConfirmation']) == 0) {
              //* Creating user
              register_p_add_user( dbhcms_f_dbvalue_to_value($row['rgpd_login_name'], DBHCMS_C_DT_STRING),
                                   dbhcms_f_dbvalue_to_value($row['rgpd_email'],      DBHCMS_C_DT_STRING),
                                   dbhcms_f_dbvalue_to_value($row['rgpd_real_name'],  DBHCMS_C_DT_STRING),
                                   dbhcms_f_dbvalue_to_value($row['rgpd_password'],   DBHCMS_C_DT_STRING)
                                 );
              //* Deleting pending registrations
              mysql_query("DELETE FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_email = '".dbhcms_f_dbvalue_to_value($row['rgpd_email'], DBHCMS_C_DT_STRING)."'");
              mysql_query("DELETE FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_login_name = '".dbhcms_f_dbvalue_to_value($row['rgpd_login_name'], DBHCMS_C_DT_STRING)."'");
              break;
            }
          }
  
          //* Showing message that registration was successfull
          dbhcms_p_add_block('registerVerificationSuccessful', array('registerMessage')); # show response message
          dbhcms_p_add_block_values('registerVerificationSuccessful', array('Your e-mail was successfully verified. You may now login.'));
          //* Hiding registration block
          dbhcms_p_hide_block('registerForm');
  
        }
      }
  
  
    //* If captcha is required to register
    if (register_f_get_config_param('requireCaptcha')) {
      //* Generating captcha number
  	  $captcha = new captchaNumber( rand(10000000,99999999) );
  	  $_SESSION['DBHCMSDATA']['TEMP']['registerCaptchaHtml'] = $captcha->htmlNumber();
  	  $_SESSION['DBHCMSDATA']['TEMP']['registerCaptchaNumber'] = $captcha->getNum();
      //* Showing message that registration was successfull
      dbhcms_p_add_block('registerCaptcha', array('registerCaptchaNumber')); 
      dbhcms_p_add_block_values('registerCaptcha', array($_SESSION['DBHCMSDATA']['TEMP']['registerCaptchaHtml']));
    } else {
      // No captcha required
      dbhcms_p_hide_block('registerCaptcha');
    }
    
    //* If password confirmation is required to register
    if (register_f_get_config_param('requirePasswordConfirmation')) {
      //* Showing password confirmation block
      dbhcms_p_add_block('registerPasswordConfirmation', array()); 
      dbhcms_p_add_block_values('registerPasswordConfirmation', array());
    } else {
      // No password confirmation is required
      dbhcms_p_hide_block('registerPasswordConfirmation');
    }
    
    //* If user name is required to register
    if (register_f_get_config_param('requireUserName')) {
      //* Showing user name block
      dbhcms_p_add_block('registerUserName', array()); 
      dbhcms_p_add_block_values('registerUserName', array());
    } else {
      // No user name is required
      dbhcms_p_hide_block('registerUserName');
    }
    
  } else {
    
    // A user is allready authenticated, so we hide the 
    // registration block
    dbhcms_p_hide_block('registerForm');
    
  }

### EOF ### (C) 2005-2016 Kai S. Bunk #######################################################

?>