<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  register                                                                                 #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Interface for users to register themselves with e-mail verification and password         #
#  recovery using the e-mail.                                                               #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  13.08.2013:                                                                              #
#  -----------                                                                              #
#  File created                                                                             #
#                                                                                           #
#############################################################################################

	define('DBHCMS_C_EXT_REGISTER', 'register');

#############################################################################################
#  SETTINGS                                                                                 #
#############################################################################################

	$ext_name 		= DBHCMS_C_EXT_REGISTER;

	$ext_title 		= 'Register';
	$ext_descr 		= 'Users registering interface';
	$ext_inmenu		= true;
	$ext_version	= '1.0';
	$ext_icon		  = 'usergroups';

	dbhcms_p_configure_extension($ext_name, $ext_title, $ext_descr, $ext_inmenu, $ext_version, $ext_icon);

#############################################################################################
#  LOAD CONFIGURATION                                                                       #
#############################################################################################

	if (in_array(DBHCMS_C_EXT_REGISTER, $GLOBALS['DBHCMS']['CONFIG']['PARAMS']['availableExtensions'])) {

		$result = mysql_query("SELECT rgcg_id, rgcg_value, rgcg_type FROM ".dbhcms_f_table_name("ext_register_config"));
		while ($row = mysql_fetch_assoc($result)) {
			dbhcms_f_array_push_assoc($GLOBALS['DBHCMS']['CONFIG']['EXT'][DBHCMS_C_EXT_REGISTER], $row['rgcg_id']);
			$GLOBALS['DBHCMS']['CONFIG']['EXT'][DBHCMS_C_EXT_REGISTER][$row['rgcg_id']] = dbhcms_f_dbvalue_to_value(dbhcms_f_str_replace_all_vars(strval($row['rgcg_value'])), $row['rgcg_type']);
		}

	}

#############################################################################################
#  GLOBAL IMPLEMENTATION                                                                    #
#############################################################################################

	function register_f_get_config_param($aparam) {
		if (isset($GLOBALS['DBHCMS']['CONFIG']['EXT'][DBHCMS_C_EXT_REGISTER][$aparam])) {
			return $GLOBALS['DBHCMS']['CONFIG']['EXT'][DBHCMS_C_EXT_REGISTER][$aparam];
		} else {
			return false;
		}
	}

	function register_p_send_email_confirmation_message($aemail, $aconfirmationurl, $arealname, $ausername) {
		if (trim($aemail) != '') {
			
			$mailto	 = $aemail;
			$subject = register_f_get_config_param('validationMailSubject');
			# get text for the mail
			$mts  	 = register_f_get_config_param('validationMailText');
			# replace values
			$mts	 = str_replace("[registrationUserName]", 	    $ausername,        $mts);
			$mts	 = str_replace("[registrationRealName]", 	    $arealname,        $mts);
			$mts	 = str_replace("[registrationConfirmationUrl]", $aconfirmationurl, $mts);
			# replace chars for html
			$mts 	 = str_replace("<br>", "\n", $mts);
			$mts 	 = strip_tags($mts);
			$mts 	 = stripslashes($mts);
			dbhcms_p_send_email(register_f_get_config_param('validationMailSender'), register_f_get_config_param('validationMailSenderName'), $mailto, $subject, $mts);

  		    $mailto  = register_f_get_config_param('validationMailSender');
		    $subject = "New registered user at ".dbhcms_f_value_to_output($GLOBALS['DBHCMS']['DOMAIN']['hostName'], DBHCMS_C_DT_STRING);
            $mts     = "The user ".$arealname." (".$aemail.") has registered at ".dbhcms_f_value_to_output($GLOBALS['DBHCMS']['DOMAIN']['hostName'], DBHCMS_C_DT_STRING)." \n\n Activation URL: ".$aconfirmationurl;	
		    dbhcms_p_send_email(register_f_get_config_param('validationMailSender'), register_f_get_config_param('validationMailSenderName'), $mailto, $subject, $mts);
		    
		}
	}

	function register_p_add_user($ausername, $aemail, $arealname, $apassword) {

      //* Obtaning default user levels for registered users
      $UserLevels = register_f_get_config_param('userLevels');
      //* Obtaning default access for domains for registered users
      $UserDomains = register_f_get_config_param('userDomains');
      //* Obtaning current language
      $UserLanguage = $_SESSION['DBHCMSDATA']['LANG']['useLanguage'];

      //* Creating user
      mysql_query( "INSERT INTO
	                 ".dbhcms_f_table_name(DBHCMS_C_TBL_USERS)."
				       ( user_login,
					     user_passwd,
						 user_name,
						 user_email,
						 user_level,
                         user_domains,
                         user_lang
					   )
				    VALUES
					   ( '".dbhcms_f_value_to_dbvalue($ausername,    DBHCMS_C_DT_STRING)."',
						 '".dbhcms_f_value_to_dbvalue($apassword,    DBHCMS_C_DT_STRING)."',
						 '".dbhcms_f_value_to_dbvalue($arealname,    DBHCMS_C_DT_STRING)."',
						 '".dbhcms_f_value_to_dbvalue($aemail,       DBHCMS_C_DT_STRING)."',
						 '".dbhcms_f_value_to_dbvalue($UserLevels,   DBHCMS_C_DT_ULARRAY)."',
                         '".dbhcms_f_value_to_dbvalue($UserDomains,  DBHCMS_C_DT_DOMAINARRAY)."',
                         '".dbhcms_f_value_to_dbvalue($UserLanguage, DBHCMS_C_DT_LANGUAGE)."'
					   )"
	             );

      //* Notifiying that user has registered
	  $NewUserId = mysql_insert_id();
      define('DBHCMS_NEW_USER_REGISTERED', $NewUserId);

	}

### EOF ### (C) 2005-2016 Kai S. Bunk #######################################################

?>
