<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  register                                                                                 #
#                                                                                           #
#  FILENAME                                                                                 #
#  =============================                                                            #
#  ext.register.inst.php                                                                    #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Interface for users to register themselves with e-mail verification and password         #
#  recovery using the e-mail.                                                               #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  13.08.2013:                                                                              #
#  -----------                                                                              #
#  File created                                                                             #
#                                                                                           #
#############################################################################################

	if (defined('DBHCMS_C_EXT_SETUP')) {

#############################################################################################
#  INSTALLATION                                                                             #
#############################################################################################

		if  (DBHCMS_C_EXT_SETUP == 'INST') {

			dbhcms_f_array_push_assoc($dbhcms_database_sql['EXT'], 'register');
			$dbhcms_database_sql['EXT']['register'] = array();

			array_push($dbhcms_database_sql['EXT']['register'], "CREATE TABLE `".DBHCMS_C_INST_DB_PREFIX."ext_register_config` (
																  `rgcg_id` varchar(150) NOT NULL default '',
																  `rgcg_value` text NOT NULL,
																  `rgcg_type` varchar(150) NOT NULL,
																  `rgcg_description` text NOT NULL,
																  PRIMARY KEY  (`rgcg_id`)
																) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;");
			array_push($dbhcms_database_sql['EXT']['register'], "INSERT INTO `".DBHCMS_C_INST_DB_PREFIX."ext_register_config` (`rgcg_id`, `rgcg_value`, `rgcg_type`, `rgcg_description`) VALUES
																	('registerPage', '0', 'DT_PAGE', 'Indicates the page with the form to register'),
                                                                    ('requireCaptcha', '1', 'DT_BOOLEAN', 'Indicates whether a captcha is required or not to register'),
                                                                    ('requireUserName', '1', 'DT_BOOLEAN', 'Indicates whether user name is required. If not, the e-mail will be used.'),
                                                                    ('requirePasswordConfirmation', '1', 'DT_BOOLEAN', 'Indicates whether the password has to written twice'),
																	('userLevels', 'A;B', 'DT_ULARRAY', 'Userlevels granted to registered users'),
                                                                    ('userDomains', '', 'DT_DOMAINARRAY', 'Domains where access is granted to registered users'),
																	('validateEmail', '1', 'DT_BOOLEAN', 'If the e-mail has to be validated'),
                                                                    ('validationMailSender', 'example@domain.com', 'DT_STRING', 'Sender e-mail of the registration confirmation message e-mail.'),
                                                                    ('validationMailSenderName', 'Sender Name', 'DT_STRING', 'The name of the sender of the registration confirmation message e-mail.'),
                                                                    ('validationMailSubject', '[domainHostName] - Registration Confirmation', 'DT_STRING', 'Subject of the registration confirmation message e-mail.'),
																	('validationMailText', 'Hello [registrationRealName]!\r\n\r\nThank you for registering. Please click on the following link to activate your account:\r\n\r\n[registrationConfirmationUrl]', 'DT_TEXT', 'Content of the e-mail for the registration confirmation message.');
																");
			array_push($dbhcms_database_sql['EXT']['register'], "CREATE TABLE `".DBHCMS_C_INST_DB_PREFIX."ext_register_pending` (
																  `rgpd_id` int(11) NOT NULL auto_increment,
																  `rgpd_login_name` varchar(150),
																  `rgpd_real_name` varchar(150),
																  `rgpd_email` varchar(150),
                                                                  `rgpd_password` varchar(150),
                                                                  `rgpd_email_confirmation_url` varchar(250),
																  PRIMARY KEY  (`rgpd_id`)
																) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;");

#############################################################################################
#  DEINSTALLATION                                                                           #
#############################################################################################

		} else if  (DBHCMS_C_EXT_SETUP == 'DEINST') {

			dbhcms_f_array_push_assoc($dbhcms_database_sql['EXT'], 'register');
			$dbhcms_database_sql['EXT']['register'] = array();

			array_push($dbhcms_database_sql['EXT']['register'], "DROP TABLE `".DBHCMS_C_INST_DB_PREFIX."ext_register_config`;");
            array_push($dbhcms_database_sql['EXT']['register'], "DROP TABLE `".DBHCMS_C_INST_DB_PREFIX."ext_register_pending`;");

		}
	}

### EOF ### (C) 2005-2016 Kai S. Bunk #######################################################

?>