<?php

#############################################################################################
#                                                                                           #
#  DBHCMS - Web Content Management System                                                   #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  COPYRIGHT NOTICE                                                                         #
#  =============================                                                            #
#                                                                                           #
#  Copyright (C) 2005-2016 Kai S. Bunk                                                      #
#  All rights reserved                                                                      #
#                                                                                           #
#  This file is part of DBHcms.                                                             #
#                                                                                           #
#  DBHcms is free software; you can redistribute it and/or modify it under the terms of     #
#  the GNU General Public License as published by the Free Software Foundation; either      #
#  version 2 of the License, or (at your option) any later version.                         #
#                                                                                           #
#  The GNU General Public License can be found at http://www.gnu.org/copyleft/gpl.html      #
#  A copy is found in the textfile GPL.TXT                                                  #
#                                                                                           #
#  DBHcms is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;      #
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         #
#  PURPOSE. See the GNU General Public License for more details.                            #
#                                                                                           #
#  This copyright notice MUST APPEAR in ALL copies of the script!                           #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  EXTENSION                                                                                #
#  =============================                                                            #
#  register                                                                                 #
#                                                                                           #
#  DESCRIPTION                                                                              #
#  =============================                                                            #
#  Interface for users to register themselves with e-mail verification and password         #
#  recovery using the e-mail.                                                               #
#                                                                                           #
#############################################################################################
#                                                                                           #
#  CHANGES                                                                                  #
#  =============================                                                            #
#                                                                                           #
#  13.08.2013:                                                                              #
#  -----------                                                                              #
#  File created                                                                             #
#                                                                                           #
#############################################################################################
# $Id: ext.register.be.php 67 2007-02-19 13:29:52Z kaisven $                                #
#############################################################################################

#############################################################################################
# BE IMPLEMENTATION - PENDING OVERVIEW                                                      #
#############################################################################################

        #==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==#
        # ACTIONS                                                                  #
        #==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==#

        if (dbhcms_f_superuser_auth() == true) {
                if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerSendConfirmationEmail'])) {
                						
			//* Searching for the corresponding pending registration
       			$users = mysql_query("SELECT * FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_id = ".intval($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerSendConfirmationEmail']));
   			if ($row = mysql_fetch_array($users)) {
            			
            			//* Sending email
            			register_p_send_email_confirmation_message(
            				dbhcms_f_dbvalue_to_value($row['rgpd_email'], 			DBHCMS_C_DT_STRING),
                        	        dbhcms_f_dbvalue_to_value($row['rgpd_email_confirmation_url'],  DBHCMS_C_DT_STRING),
                                        dbhcms_f_dbvalue_to_value($row['rgpd_real_name'],  		DBHCMS_C_DT_STRING),
                                        dbhcms_f_dbvalue_to_value($row['rgpd_login_name'],   		DBHCMS_C_DT_STRING)
                                );
            			
            			$action_result = '<div style="color: #076619; font-weight: bold;">Confirmation e-mail has been sent</div>';
            			
        		} else {
        			$action_result = '<div style="color: #FF0000; font-weight: bold;">ERROR! - Could not send confirmation e-mail.</div>';        			
        		}
						
                } else if (isset($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerActivateUser'])) {
                
        			//* Searching for the corresponding pending registration
       				$users = mysql_query("SELECT rgpd_login_name, rgpd_email, rgpd_real_name, rgpd_password FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_id = ".intval($GLOBALS['DBHCMS']['TEMP']['PARAMS']['registerActivateUser']));
   			 		if ($row = mysql_fetch_array($users)) {
            			//* Creating user
            			register_p_add_user( dbhcms_f_dbvalue_to_value($row['rgpd_login_name'], DBHCMS_C_DT_STRING),
                                 dbhcms_f_dbvalue_to_value($row['rgpd_email'],      DBHCMS_C_DT_STRING),
                                 dbhcms_f_dbvalue_to_value($row['rgpd_real_name'],  DBHCMS_C_DT_STRING),
                                 dbhcms_f_dbvalue_to_value($row['rgpd_password'],   DBHCMS_C_DT_STRING)
                               );
            			//* Deleting pending registrations
            			mysql_query("DELETE FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_email = '".mysql_real_escape_string($row['rgpd_email'])."'");
            			mysql_query("DELETE FROM ".dbhcms_f_table_name("ext_register_pending")." WHERE rgpd_login_name = '".mysql_real_escape_string($row['rgpd_login_name'])."'");
            			
            			$action_result = '<div style="color: #076619; font-weight: bold;">Activated user "'.$row['rgpd_login_name'].'"</div>';
            			
        			} else {
        				$action_result = '<div style="color: #FF0000; font-weight: bold;">ERROR! - Could not activate user.</div>';        			
        			}
							
                }
        }

        #==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==#
        # PENDING LIST                                                             #
        #==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==##==#

        $pendingUsers = '';
        $i = 0;
        $result = mysql_query("SELECT * FROM ".dbhcms_f_table_name("ext_register_pending"));
        while ($row = mysql_fetch_assoc($result)){
                
			if ($i & 1) {
				$pendingUsers .= '<tr onmouseover="this.bgColor = \'#D2D4FF\'" onmouseout="this.bgColor = \'#DEDEDE\'" bgcolor="#DEDEDE">';
			} else {
				$pendingUsers .= '<tr onmouseover="this.bgColor = \'#D2D4FF\'" onmouseout="this.bgColor = \'#F0F0F0\'" bgcolor="#F0F0F0">';
			}
                
                $pendingUsers .= '<td align="center" width="20">'.dbhcms_f_get_icon('male').'</td>';
                
                
                $pendingUsers .= '<td><strong>'.htmlspecialchars(dbhcms_f_dbvalue_to_value($row['rgpd_login_name'], DBHCMS_C_DT_STRING)).'</strong></td>';
                $pendingUsers .= '<td>'.htmlspecialchars(dbhcms_f_dbvalue_to_value($row['rgpd_real_name'], DBHCMS_C_DT_STRING)).'</td>';
                $pendingUsers .= '<td>'.htmlspecialchars(dbhcms_f_dbvalue_to_value($row['rgpd_email'], DBHCMS_C_DT_STRING)).'</td>';
                $pendingUsers .= '<td>'.htmlspecialchars(dbhcms_f_dbvalue_to_value($row['rgpd_email_confirmation_url'], DBHCMS_C_DT_STRING)).'</td>';
                $pendingUsers .= '<td align="center" width="20"><a title="Activate" href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_REGISTER, 'registerBePart' => 'pending', 'registerActivateUser' => $row['rgpd_id'])).'">'.dbhcms_f_get_icon('key', 'Activate').'</a></td>';
                $pendingUsers .= '<td align="center" width="20"><a title="Send Activation Email" href="'.dbhcms_f_get_url_from_pid_wp($GLOBALS['DBHCMS']['PID'], array('ext' => DBHCMS_C_EXT_REGISTER, 'registerBePart' => 'pending', 'registerSendConfirmationEmail' => $row['rgpd_id'])).'">'.dbhcms_f_get_icon('mail-forward', 'Send Activation Email', 1).'</a></td></tr>';
                $i++;
        }
        
        dbhcms_p_add_string('registerPending', $pendingUsers);
    

?>