/*
 * Decompiled with CFR 0.152.
 */
package gota;

import gota.Gota;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PasswordDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected String username;
    protected String buttonClicked;
    protected String goUrl;
    final JPasswordField txtPassword;

    public PasswordDialog(JFrame parent, String title, String message, String goUrl, String username) {
        super(parent, title, true);
        this.username = username;
        this.goUrl = goUrl;
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        Image icon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/GO16x16.gif"));
        this.setIconImage(icon);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel lblText = new JLabel("<html>" + Gota.lang.getString("txtEnterPassword") + "<html>");
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)lblText, c);
        this.txtPassword = new JPasswordField(10);
        JLabel lblPassword = new JLabel(Gota.lang.getString("txtPassword") + ":");
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.add((Component)lblPassword, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.txtPassword, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        JButton btnLogin = new JButton(Gota.lang.getString("btnOk"));
        btnLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordDialog.this.login()) {
                    PasswordDialog.this.setVisible(false);
                    PasswordDialog.this.dispose();
                }
            }
        });
        this.add((Component)btnLogin, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        JButton btnCancel = new JButton(Gota.lang.getString("btnCancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.buttonClicked = "CANCEL";
                PasswordDialog.this.setVisible(false);
                PasswordDialog.this.dispose();
            }
        });
        this.add((Component)btnCancel, c);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(300, 120);
        this.setVisible(true);
    }

    public String getButtonClicked() {
        return this.buttonClicked;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public final boolean login() {
        String password = "";
        char[] inputPassword = this.txtPassword.getPassword();
        for (int i = 0; i < inputPassword.length; ++i) {
            password = password + inputPassword[i];
        }
        String data = "username=" + this.username + "&password=" + password;
        Gota.info("Login data: " + data);
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        try {
            String line;
            URL url = new URL(this.goUrl + "?r=auth/login");
            URLConnection conn = url.openConnection();
            Gota.info("Checkin URL: " + url.toString());
            conn.setDoOutput(true);
            conn.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            StringBuilder response = new StringBuilder();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            Gota.info(response.toString());
            Object obj = JSONValue.parse(response.toString());
            JSONObject jsonObj = (JSONObject)obj;
            Boolean success = (Boolean)jsonObj.get("success");
            Gota.sid = (String)jsonObj.get("sid");
            Gota.securityToken = (String)jsonObj.get("security_token");
            Gota.info("New Session ID: " + Gota.sid);
            Gota.info("New Security Token: " + Gota.securityToken);
            if (!success.booleanValue()) {
                JOptionPane.showMessageDialog(new JFrame(), (String)jsonObj.get("feedback"), Gota.lang.getString("txtError"), 2);
                Gota.info((String)jsonObj.get("feedback"));
            }
            return success;
        }
        catch (Exception e) {
            Gota.error("Exception in login process");
            Gota.error(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

