/*
 * Decompiled with CFR 0.152.
 */
package gota.httpclient;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class HttpInputStream
extends FilterInputStream {
    private StringBuffer buffer = new StringBuffer();
    private boolean endOfHeader = false;

    public HttpInputStream(InputStream in) {
        super(new BufferedInputStream(in));
    }

    public boolean endOfHeader() {
        return this.endOfHeader;
    }

    public String readLine() throws IOException {
        int read;
        if (this.endOfHeader) {
            throw new IllegalStateException("YOU CAN NOT READ TEXT LINES AFTER THE END OF THE HTTP HEADER");
        }
        this.buffer.delete(0, this.buffer.length());
        while ((read = this.read()) != -1) {
            if (read == 13) {
                if (this.read() != 10) {
                    throw new IOException("MALFORMED HTTP HEADER (NEED CRLF)");
                }
                if (this.buffer.length() == 0) {
                    this.endOfHeader = true;
                }
                return this.buffer.toString();
            }
            this.buffer.append((char)read);
        }
        throw new IOException("INCOMPLETE HTTP HEADER (END OF STREAM)");
    }
}

