<?php

/*
 * This file is part of SwiftMailer.
 * (c) 2004-2009 Chris Corbyn
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Logs events in the Transport system.
 *
 * @package    Swift
 * @subpackage Transport
 * @author     Chris Corbyn
 */
interface Swift_Plugins_Logger
{
    /**
     * Add a log entry.
     *
     * @param StringHelper $entry
     */
    public function add($entry);

    /**
     * Clear the log contents.
     */
    public function clear();

    /**
     * Get this log as a string.
     *
     * @return StringHelper
     */
    public function dump();
}
