<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use File;

class UpdateKPPW extends Command
{
    
    protected $signature = 'update:kppw';

    
    protected $description = 'this is kppw update engine';

    
    protected $updatePath;
    
    protected $updateTime;
    
    protected $migrationPath;
    
    protected $seederPath;

    
    public function __construct()
    {
        parent::__construct();
		
		$this->updateTime = config('kppw.kppw_update_time');

        $this->updatePath = base_path('update');

        $this->seederPath = database_path('seeds/' . $this->updateTime);

        $this->migrationPath = 'database/migrations/' . $this->updateTime;


    }

    
    public function handle()
    {

        $start = $this->confirm('Please back up the database and the program before you upgrade!!!');

        if ($start){

            $status = File::copyDirectory($this->updatePath, base_path());


            if ($status){
                
                $this->call('migrate', [
                    '--path' => $this->migrationPath
                ]);

                
                $files = File::files($this->seederPath);

                foreach ($files as $file){
                    $filename[] = basename($file, '.' . File::extension($file));
                }

                if(!empty($filename)){
                    foreach ($filename as $seed){
                        Artisan::call('db:seed', [
                            '--class' => $seed
                        ]);
                    }
                }



                
                File::deleteDirectory($this->updatePath);
            }
			$this->info('update success');
        }

        
    }
}
