﻿(function () {
    if (window.dt_$ && window.daitui) {
        return false
    }
    var $ = {
        byId: function (id) {
            return document.getElementById(id)
        },
        byName: function (name) {
            return $.toArray(document.getElementsByName(name))
        },
        byTag: function (tag, obj) {
            obj = obj || document;
            return $.toArray(obj.getElementsByTagName(tag))
        },
        byClass: function (cls, obj) {
            obj = obj || document;
            var re = new RegExp("(^|\\s+)" + $.addSlashRegExp(cls) + "(\\s+|$)");
            var ret = [],
                arr = obj.getElementsByTagName('*');
            for (var i = 0; i < arr.length; i++) {
                if (re.test(arr[i].className)) {
                    ret[ret.length] = arr[i]
                }
            }
            return ret
        },
        toArray: function (obj) {
            var arr = [];
            for (var i = 0; i < obj.length; i++) {
                arr[i] = obj[i]
            }
            return arr
        },
        attr: function (obj, name) {
            var value = obj[name] ? obj[name] : obj.getAttribute(name);
            return !value ? "" : value
        },
        create: function (tag) {
            return document.createElement(tag)
        },
        next: function (node, all) {
            var ret = node;
            while (ret = ret.nextSibling) {
                if (all || ret.nodeType == 1) {
                    break
                }
            }
            return ret
        },
        prev: function (node, all) {
            var ret = node;
            while (ret = ret.previousSibling) {
                if (all || ret.nodeType == 1) {
                    break
                }
            }
            return ret
        },
        before: function (refer, node) {
            return refer.parentNode.insertBefore(node, refer)
        },
        after: function (refer, node) {
            var ret, next = $.next(refer);
            if (next) {
                ret = $.before(next, node)
            } else {
                ret = $.append(refer.parentNode, node)
            }
            next = null;
            return ret
        },
        prepend: function (parent, node) {
            var ret;
            if (parent.hasChildNodes()) {
                ret = $.before(parent.childNodes[0], node)
            } else {
                ret = $.append(parent, node)
            }
            return ret
        },
        append: function (parent, node) {
            return parent.appendChild(node)
        },
        remove: function (node) {
            if (node && node.parentNode) {
                return node.parentNode.removeChild(node)
            } else {
                return false
            }
        },
        bind: function (obj, evt, callback) {
            var arr = [];
            if (obj.constructor == Array) {
                arr = obj
            } else {
                arr[arr.length] = obj
            }
            for (var i = 0; i < arr.length; i++) {
                if (arr[i].addEventListener) {
                    arr[i].addEventListener(evt, callback, 0)
                } else if (obj.attachEvent) {
                    arr[i].attachEvent("on" + evt, callback)
                } else {
                    arr[i]["on" + evt] = callback
                }
            }
        },
        addClass: function (obj, cls) {
            obj.className = $.trim(obj.className + " " + cls)
        },
        removeClass: function (obj, cls) {
            var re = new RegExp("(^|\\s+)" + $.addSlashRegExp(cls) + "(\\s+|$)", "g");
            obj.className = $.trim(obj.className.replace(re, " "))
        },
        addSlash: function (str, list) {
            var re = new RegExp("([" + $.addSlashRegExp(list) + "])", "g");
            list = list || "\"\'\t\r\n\\";
            return str.replace(re, "\\$1")
        },
        addSlashRegExp: function (str) {
            return str.replace(/([\^\$\*\+\?\(\)\[\]\{\}\,\.\:\=\!\|\-\\])/g, "\\$1")
        },
        trim: function (str) {
            return str.replace(/(^[\r\n\s]+|[\r\n\s]+$)/g, "")
        },
        curCss: function (elem, name) {
            var ret, style = elem.style;
            if (name.match(/float/i)) name = "styleFloat";
            if (document.defaultView && document.defaultView.getComputedStyle) {
                if (name.match(/float/i)) name = "float";
                name = name.replace(/([A-Z])/g, "-$1").toLowerCase();
                var computedStyle = document.defaultView.getComputedStyle(elem, null);
                if (computedStyle) ret = computedStyle.getPropertyValue(name)
            } else if (elem.currentStyle) {
                var camelCase = name.replace(/\-(\w)/g, function (all, letter) {
                    return letter.toUpperCase()
                });
                ret = elem.currentStyle[name] || elem.currentStyle[camelCase];
                if (!/^\d+(px)?$/i.test(ret) && /^\d/.test(ret)) {
                    var left = style.left,
                        rsLeft = elem.runtimeStyle.left;
                    elem.runtimeStyle.left = elem.currentStyle.left;
                    style.left = ret || 0;
                    ret = style.pixelLeft + "px";
                    style.left = left;
                    elem.runtimeStyle.left = rsLeft
                }
            } else if (style && style[name]) ret = style[name];
            return ret
        },
        getOffset: function (obj) {
            var info = {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
                right: 0,
                bottom: 0
            };
            if (obj == "visible") {
                if (window.innerWidth && window.innerWidth.constructor == Number) {
                    info.width = window.innerWidth;
                    info.height = window.innerHeight;
                    info.left = window.pageXOffset;
                    info.top = window.pageYOffset
                } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
                    info.width = document.documentElement.clientWidth;
                    info.height = document.documentElement.clientHeight;
                    info.left = document.documentElement.scrollLeft;
                    info.top = document.documentElement.scrollTop
                } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
                    info.width = document.body.clientWidth;
                    info.height = document.body.clientHeight;
                    info.left = document.body.scrollLeft;
                    info.top = document.body.scrollTop
                }
            } else {
                info.width = obj.offsetWidth;
                info.height = obj.offsetHeight;
                var abs_pos = false;
                var abs_parent = document.body;
                while (obj) {
                    info.left += obj.offsetLeft;
                    info.top += obj.offsetTop;
                    if ($.browser.msie && $.boxModel && obj.offsetParent && !/^t(able|d|h)$/i.test(obj.tagName)) {
                        info.left += obj.clientLeft;
                        info.top += obj.clientTop
                    }
                    if ($.browser.mozilla) {
                        info.left += parseInt($.curCss(obj, "borderLeftWidth"));
                        info.top += parseInt($.curCss(obj, "borderTopWidth"));
                        $.log(obj.tagName + "border" + $.curCss(obj, "borderLeftWidth") + "//" + $.curCss(obj, "borderTopWidth"))
                    }
                    $.log(obj.tagName + "/" + $.boxModel + "/" + obj.nodeType + "/" + "OL:OT//CL:CT" + obj.offsetLeft + ":" + obj.offsetTop + "//" + obj.clientLeft + ":" + obj.clientTop);
                    if ($.curCss(obj, 'position').toLowerCase() == 'absolute') {
                        abs_pos = true
                    }
                    if (abs_pos && $.curCss(obj, 'position').toLowerCase() == 'relative') {
                        abs_parent = obj
                    }
                    obj = obj.offsetParent
                }
                if (!abs_pos || abs_parent != document.body) {
                    if ($.browser.msie && $.boxModel) {
                        info.left += document.body.clientLeft;
                        info.top += document.body.clientTop;
                        $.log("body-client" + document.body.clientLeft + "//" + document.body.clientTop)
                    }
                    if ($.browser.mozilla) {
                        info.left += document.body.clientLeft;
                        info.top += document.body.clientTop;
                        $.log("body-client" + document.body.clientLeft + "//" + document.body.clientTop);
                        if (document.body.offsetLeft + document.body.clientLeft != 0) {
                            info.left -= document.body.offsetLeft;
                            info.top -= document.body.offsetTop
                        }
                        info.left += parseInt($.curCss(document.documentElement, "marginLeft"));
                        info.top += parseInt($.curCss(document.documentElement, "marginTop"));
                        $.log("html-margin" + parseInt($.curCss(document.documentElement, "marginLeft")) + "//" + parseInt($.curCss(document.documentElement, "marginTop")))
                    }
                }
            }
            info.right = info.left + info.width;
            info.bottom = info.top + info.height;
            $.log("WH//TRBL=" + info.width + ":" + info.height + "//" + info.top + ":" + info.right + ":" + info.bottom + ":" + info.left);
            return info
        },
        cancelEvent: function (evt) {
            if (evt.preventDefault) {
                evt.preventDefault()
            }
            evt.returnValue = false
        },
        urlencode: encodeURIComponent,
        urldecode: decodeURIComponent,
        log: function (m) {
            if (window.daitui_logger && window.daitui_logger.constructor == Function) {
                window.daitui_logger(m)
            }
        },
        boxModel: true,
        boxModelTest: function () {
            if (!document.body) {
                setTimeout(arguments.callee, 10);
                return
            }
            var div = $.create("div");
            div.style.padding = div.style.margin = "0";
            div.style.border = "none";
            div.style.width = div.style.paddingLeft = "1px";
            $.prepend(document.body, div);
            $.boxModel = div.offsetWidth === 2;
            $.remove(div);
            div.style.display = 'none';
            div = null
        },
        ready: function (fn) {
            $.domReadyBind();
            if ($.domReady) {
                fn.call(document, $)
            } else {
                $.domReadyList.push(fn)
            }
        },
        domReady: false,
        domReadyList: [],
        domReadyBound: false,
        domReadyBind: function () {
            if ($.domReadyBound) return;
            $.domReadyBound = true;
            if (document.addEventListener) {
                document.addEventListener("DOMContentLoaded", function () {
                    document.removeEventListener("DOMContentLoaded", arguments.callee, false);
                    $.domReadyDone()
                },
                false)
            } else if (document.attachEvent) {
                document.attachEvent("onreadystatechange", function () {
                    if (document.readyState === "complete") {
                        document.detachEvent("onreadystatechange", arguments.callee);
                        $.domReadyDone()
                    }
                });
                if (document.documentElement.doScroll && window == window.top)(function () {
                    if ($.domReady) return;
                    try {
                        document.documentElement.doScroll("left")
                    } catch(error) {
                        setTimeout(arguments.callee, 0);
                        return
                    }
                    $.domReadyDone()
                })()
            }
            $.bind(window, "load", $.domReadyDone)
        },
        domReadyDone: function () {
            if (!$.domReady) {
                $.domReady = true;
                if ($.domReadyList) {
                    for (var i = 0; i < $.domReadyList.length; i++) {
                        $.domReadyList[i].call(document, $)
                    }
                    $.domReadyList = null
                }
            }
        },
        fixIeBgBug: function () {
            try {
                document.execCommand("BackgroundImageCache", false, true)
            } catch(e) {}
        },
        loadCssFile: function (file) {
            var css = $.create("link");
            css.rel = css.rev = "stylesheet";
            css.type = "text/css";
            css.media = "all";
            css.href = file;
            $.prepend($.byTag("head")[0], css);
            css = null
        },
        getUrlParams: function (url) {
            var params = {};
            var arr = url.replace(/^[^\?]+(\?|$)/, "").split("&");
            for (var i = 0; i < arr.length; i++) {
                var pos = arr[i].indexOf("=");
                if (pos == -1) {
                    continue
                }
                params[arr[i].substr(0, pos)] = arr[i].substr(pos + 1)
            }
            return params
        },
        joinLink: function (base, args) {
            var ret = base,
                arr = [];
            for (var idx in args) {
                arr[arr.length] = idx + "=" + args[idx]
            }
            ret += arr.sort().join("&");
            return ret
        }
    };
    var userAgent = navigator.userAgent.toLowerCase();
    $.browser = {
        version: (userAgent.match(/.+(?:rv|it|ra|ie)[\/:]([\d.]+)/) || [0, '0'])[1],
        safari: /webkit/.test(userAgent),
        opera: /opera/.test(userAgent),
        msie: /msie/.test(userAgent) && !/opera/.test(userAgent),
        mozilla: /mozilla/.test(userAgent) && !/(compatible|webkit)/.test(userAgent)
    };
    var $$ = {
        STYLESHEET_URL: "http://one.uscms.cn/js/global.css",
        SERVICE_URL: "http://one.uscms.cn/bookmark?",
        TIME_DELAY_OVER: 0,
        TIME_DELAY_OUT: 500,
        init: function () {
            $.fixIeBgBug();
            $.loadCssFile($$.STYLESHEET_URL);
            $$.initButtons();
            $.ready($$.initButtons)
        },
        initButtons: function () {
            if (!document.body) {
                setTimeout(arguments.callee, 10);
                return
            }
            var btns = $.byClass("dt_button");
            for (var i = 0; i < btns.length; i++) {
                $$.initWidget(btns[i])
            }
            btns = null
        },
        initWidget: function (btn) {
            if (btn._init_locked) {
                return false
            }
            btn._init_locked = true;
            btn._mouseover_sub = function (force) {
                btn._time_over = (new Date).getTime();
                btn._cancel_out = true;
                btn._cancel_over = false;
                var _time_last_over = btn._time_over;
                var _time_delay = force ? 0 : $$.TIME_DELAY_OVER;
                if (btn._load_locked) {
                    return false
                }
                setTimeout(function () {
                    if (!force && (btn._cancel_over || _time_last_over != btn._time_over)) {
                        return false
                    }
                    btn._load_locked = true;
                    btn._cancel_over = true;
                    btn._time_over = 0;
                    var dropdown = $.create("div");
                    dropdown.style.background = "#ECFFAF";
                    dropdown.style.position = "absolute";
                    dropdown.style.textAlign = "left";
                    dropdown.style.visibility = "hidden";
                    $.addClass(dropdown, "dt_dropdown");
                    var bgfrm = $.create("iframe");
                    bgfrm.frameBorder = "0";
                    bgfrm.scrolling = "no";
                    bgfrm.style.position = "absolute";
                    bgfrm.src = "javascript:'';";
                    $.addClass(bgfrm, "dt_bgfrm");
                    $.append(dropdown, bgfrm);
                    var fgdiv = $.create("div");
                    fgdiv.style.position = "relative";
                    $.addClass(fgdiv, "dt_fgdiv");
                    $.append(dropdown, fgdiv);
                    $.prepend(document.body, dropdown);
                    btn._dropdown_node = dropdown;
                    var providers = {
                        'special_favorite': '浏览器收藏夹',
                        'baidu': '百度搜藏',
                        'google': '谷歌书签',
                        'yahoo': '雅虎收藏',
                        'qq': 'QQ书签',
                        'sina': '新浪ViVi',
                        'diguff': '嘀享-嘀咕',
                        'zuosa': '做啥网',
                        'v_sohu': '新浪微博',
                        'xiezhua': '蟹爪',
                        'kaixin001': '开心网',
                        '9_douban': '豆瓣9点',
                        'renren': '人人网',
                        'bai_sohu': '搜狐白社会',
                        '115': '115收藏夹',
                        'haoei': '好诶网',
                        'shouker': '收客网',
                        'waakee': '挖客网',
                        'diglog': '奇客发现',
                        'yangku': '央库',
                        '9fav': '就喜欢',
                        'leshou': '乐收网',
                        'mister-wong': 'Mister Wong',
                        'delicious': 'Delicious',
                        'live': 'Windows Live',
                        'digg': 'Digg This',
                        'facebook': 'Facebook',
                        'twitter': 'Twitter'
                    };
                    var html = "";
                    html += '<ul class="dt_list">';
                    for (var key in providers) {
                        html += '<li><a class="dt_a p_' + key + '" dt_provider="' + key + '" href="#" rel="nofollow" target="_blank"><span class="dt_a_ico">' + providers[key] + '</span></a></li>'
                    }
                    html += '</ul>';
                    html += '<div style="clear:both;line-height:0"></div>';
                    html += '<div class="dt_foot"><a href="http://www.uscms.cn">优势淘宝分享工具</a></div>';
                    fgdiv.innerHTML = html;
                    var args = $.getUrlParams(btn.href);
                    if ($.attr(btn, "dt_title")) args["title"] = $.attr(btn, "dt_title");
                    if ($.attr(btn, "dt_link")) args["link"] = $.attr(btn, "dt_link");
                    if ($.attr(btn, "dt_tag")) args["tag"] = $.attr(btn, "dt_tag");
                    if ($.attr(btn, "dt_note")) args["note"] = $.attr(btn, "dt_note");
                    var links = $.byClass("dt_a", fgdiv);
                    for (var i = 0; i < links.length; i++) {
                        args["provider"] = $.attr(links[i], "dt_provider");
                        if (!args["title"]) {
                            args["title"] = $.urlencode(document.title)
                        }
                        if (!args["link"]) {
                            args["link"] = $.urlencode(self.location.href)
                        }
                        links[i].href = $.joinLink($$.SERVICE_URL, args);
                        if (args["provider"].indexOf("special_") == 0) {
                            $$.bindSpecialEvent(links[i])
                        }
                    }
                    if (!$.boxModel) {
                        fgdiv.style.width = (fgdiv.clientWidth + parseInt($.curCss(fgdiv, "paddingLeft")) + parseInt($.curCss(fgdiv, "paddingRight")) + parseInt($.curCss(fgdiv, "borderLeftWidth")) + parseInt($.curCss(fgdiv, "borderRightWidth"))) + "px"
                    }
                    dropdown.style.width = bgfrm.style.width = fgdiv.offsetWidth + "px";
                    dropdown.style.height = bgfrm.style.height = fgdiv.offsetHeight + "px";
                    var info_btn = $.getOffset($.byTag("img", btn)[0] ? $.byTag("img", btn)[0] : btn);
                    var info_visible = $.getOffset("visible");
                    var info_dropdown = $.getOffset(dropdown);
                    var left = 0,
                        top = 0;
                    if (info_visible.right >= info_btn.left + info_dropdown.width || info_visible.right - (info_btn.left + info_dropdown.width) >= (info_btn.right - info_dropdown.width) - info_visible.left) {
                        left = info_btn.left
                    } else {
                        left = info_btn.right - info_dropdown.width
                    }
                    if (info_visible.bottom >= info_btn.bottom + info_dropdown.height || info_visible.bottom - (info_btn.bottom + info_dropdown.height) >= (info_btn.top - info_dropdown.height) - info_visible.top) {
                        top = info_btn.bottom
                    } else {
                        top = info_btn.top - info_dropdown.height
                    }
                    dropdown.style.left = left + "px";
                    dropdown.style.top = top + "px";
                    $.bind([dropdown], "mouseover", function () {
                        if (!btn._dropdown_node) {
                            btn._dropdown_node = this;
                            btn._load_locked = true
                        }
                        btn._mouseover_sub()
                    });
                    $.bind([dropdown], "mouseout", function () {
                        btn._mouseout_sub()
                    });
                    dropdown.style.visibility = "visible";
                    dropdown = bgfrm = fgdiv = links = null
                },
                _time_delay)
            };
            btn._mouseout_sub = function (force) {
                btn._time_out = (new Date).getTime();
                btn._cancel_over = true;
                btn._cancel_out = false;
                var _time_last_out = btn._time_out;
                var _time_delay = force ? 0 : $$.TIME_DELAY_OUT;
                setTimeout(function () {
                    if (!force && (btn._cancel_out || _time_last_out != btn._time_out)) {
                        return false
                    }
                    btn._load_locked = false;
                    btn._cancel_out = true;
                    btn._time_out = 0;
                    $.remove(btn._dropdown_node);
                    btn._dropdown_node = null
                },
                _time_delay)
            };
            $.bind([btn], "click", function (evt) {
                btn._mouseover_sub(true);
                $.cancelEvent(evt || event);
                return false
            });
            $.bind([btn], "mouseover", function () {
                btn._mouseover_sub()
            });
            $.bind([btn], "mouseout", function () {
                btn._mouseout_sub()
            })
        },
        bindSpecialEvent: function (link) {
            $.bind([link], "click", function (evt) {
                var args = $.getUrlParams(this.href);
                args["provider"] = $.attr(this, "dt_provider");
                var s_title = $.urldecode(args["title"]);
                var s_link = $.urldecode(args["link"]);
                switch (args["provider"]) {
                case "special_favorite":
                    try {
                        window.external.AddFavorite(s_link, s_title)
                    } catch(e) {
                        try {
                            window.sidebar.addPanel(s_title, s_link, "")
                        } catch(e) {
                            alert("使用快捷键 Ctrl+D 或 Cmd+D 来收藏此页！")
                        }
                    }
                    break;
                default:
                    break
                }
                $.cancelEvent(evt || event);
                return false
            })
        }
    };
    $.boxModelTest();
    window.dt_$ = $;
    window.daitui = $$
})();