<?php
/* Project JiNan
*
* Author: Explon
*
* Copyright (C) 2007 Explon <explon@gmail.com>
*/

define('TAG_PREFIX', '{');
define('TAG_SUFFIX', '}');

class Template
{
	var $html;
	var $files;
	
	function __construct($file)
	{
		$this->Init($file);
	}
	
	private function Init($file)
	{
		$this->html = $this->Get('header');
		$this->html .= $this->Get($file);
		$this->html .= $this->Get('footer');
	}
	
	private function Load($template)
	{
		$this->html = file_get_contents("template/" . $template . ".html");
	}

	function Get($template)
	{		
		return file_get_contents("template/" . $template . ".html");
	}
	
	function Add($target, $tag)
	{
		$this->html = str_replace(TAG_PREFIX . '$content.' . $tag . TAG_SUFFIX, $target, $this->html);
	}
	
	function Set($data, $tag)
	{
		$this->html = str_replace(TAG_PREFIX . '$' . $tag . TAG_SUFFIX, $data, $this->html);
	}
}

?>