<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# POSH Users management - Delete a user group
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

require_once('../includes/xml.inc.php');
require_once('../includes/log.inc.php');

$group=0;
$group = $_REQUEST["groupid"];
$groupname = isset($_REQUEST["groupname"])?$_REQUEST["groupname"]:'';

$file=new xmlFile();
$file->header("groupsupp");

$groupArr = array();
$groupArr['id'] = $group;
$groupArr['name'] = $groupname;
launch_hook('admin_scr_group_delete',$groupArr);

//delete in user_group
$DB->execute($users_deleteGroup,$DB->escape($group));
//delete admin group mapping
$DB->execute($admin_removeFromGroupByGroup,$DB->escape($group));

$log=new log();
$log->addLog($DB,'group suppression (NAME:'.$groupname.';ID:'.$group.')');

if (__GROUP_RESTRICTION_ON_SINGLE_WIDGET) {
    $DB->execute($module_deleteUserGroupMappingByGroup,$DB->escape($group));
}

//delete pages of that group / pages_module
$DB->getResults($pages_getGroupPages,$DB->escape($group));
while ($row=$DB->fetch(0)) {
    $pageid=$row['id'];
    $DB->execute($pages_removePage,$DB->escape($pageid));
    $DB->execute($pages_removeModules,$DB->escape($pageid));
    $DB->execute($users_deleteProfileModules,$DB->escape($pageid));
    $DB->execute($users_deleteToUpdateTabsByPageId,$DB->escape($pageid));
}

$file->status(1);
$file->footer();
?>