<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# POSH Module management - Apply module modifications
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

$folder="";
$not_access=1;
$isScript=true;
$isPortal=false;
$granted="A";
$pagename="admin/scr_module_modify.php";
//includes
require_once("includes.php");
require_once('../includes/refreshcache.inc.php');
require_once('../includes/misc.inc.php');
require_once('../includes/xml.inc.php');
require_once('../includes/log.inc.php');

launch_hook('admin_scr_module_modify');

//control that the current administrator has access to the script
$grantedCalls = array("modulestab");
require('adm_ctrl_access.php');

// Get the ID of the treated module
$itemid=isset($_POST["itemid"])?$_POST["itemid"]:-1;
$catidList=isset($_POST["catid"])?$_POST["catid"]:-1;
$oldcatidList=isset($_POST["oldcatid"])?$_POST["oldcatid"]:-1;

$catId = explode(',',$catidList);
$oldCatId = explode(',',$oldcatidList);
$allCatId = explode(',',$oldcatidList.','.$catidList);

$icon=isset($_POST["icon"])?$_POST["icon"]:"";

$sizable = 1;
$DB->getResults($module_getModule,$DB->escape($itemid));
$row = $DB->fetch(0);
$sizable = $row["sizable"];

// Save module changes
$minwidth=isset($_POST["minwidth"])?$_POST["minwidth"]:0;
/*
$sizable=1;
if ($minwidth==400) $sizable=0;
*/

$url=isset($_POST["url"])?$_POST["url"]:"";
if (strpos($url,"?")===false) {
	$url.="?";
}
//else
//{
//	$url.="&";
//}
$name = isset($_POST["name"])?$_POST["name"]:"";
$desc = isset($_POST["desc"])?$_POST["desc"]:"";
$typ = isset($_POST["typ"])?$_POST["typ"]:"";
$status = isset($_POST["status"])?$_POST["status"]:"";
$size = isset($_POST["size"])?$_POST["size"]:"";
$website = isset($_POST["website"])?$_POST["website"]:"";
$views = isset($_POST["views"])?$_POST["views"]:"";
$hidden = isset($_POST["hidden"])?$_POST["hidden"]:0;
$defvar = isset($_POST["defvar"])?$_POST["defvar"]:'';
$sizable = isset($_POST["sizable"])?$_POST["sizable"]:$sizable;

/*
    $module_updateModule is used in scr_module_validate.php and scr_module_validateall.php and scr_module_modify.php
*/
$DB->execute($module_updateModule,$DB->quote($url),
								$DB->quote($defvar),
								$DB->quote($name),
								$DB->quote($desc),
								$DB->quote($typ),
								$DB->quote($status),
								$DB->escape($size),
								$DB->escape($minwidth),
								$DB->escape($sizable),
								$DB->quote($website),
								$DB->quote($views ),
                                $DB->quote($hidden ),
								$DB->escape($itemid)
							);
launch_hook('tutorial_update_widget_ressource', 'updateWidgetRessourceId',$defvar,$desc,$name);
$log=new log();

if ( $status=="S" )
{
	foreach ($catId AS $catIdElement)
	{
		$DB->execute($module_deleteModuleCategory,$DB->escape($itemid),$DB->escape($catIdElement));
	}
	launch_hook('tutorial_delete_widget_ressource', 'deleteWidgetRessourceId',$itemid);
	$log->addLog($DB,'Widget suppression (NAME:'.$name.';ID:'.$itemid.')');
}
else {
	$first = 'Y';
	
	//remove old mapping
	foreach ($oldCatId AS $oldCatIdElement)
	{
		$DB->execute($module_deleteModuleCategory,$DB->escape($itemid),$DB->escape($oldCatIdElement));
	}
	
	foreach ($catId AS $catIdElement)
	{
		if ( $catIdElement != 0 ) {
			//$DB->getResults($module_getModuleDirectory,$DB->escape($itemid));
			//if ($DB->nbResults()==0)    {		
			$DB->execute($module_addModuleDirectory,$DB->escape($itemid),$DB->escape($catIdElement),$DB->quote($first));
			//}
			//else {
				//update the mapping
				//$DB->execute($module_updateModuleDirectory,$DB->escape($catIdElement),$DB->escape($itemid));
			//}
			$first = 'N';
		}
	}
	$log->addLog($DB,'Widget modification (NAME:'.$name.';ID:'.$itemid.')');
}

// Suppress the module keywords
$DB->execute($module_removeKeywords,$DB->escape($itemid));

// add the module new keywords
for ($i=0;$i<40;$i++)
{
	if (!empty($_POST["kw".$i]))
	{
		$kw=$_POST["kw".$i];
		$kwsimplified=trim(suppress_accent($kw));
		$kw=$kwsimplified;
		$kwsimplified=strtolower($kwsimplified);
		$DB->getResults($module_getKeyword,$DB->quote($kwsimplified));
		if ($DB->nbResults()==0)
		{
			$DB->execute($module_addKeyword,$DB->quote($kw),$DB->quote($kwsimplified));
			$kwid=$DB->getId();
		}
		else
		{
			$row = $DB->fetch(0);
			$kwid=$row["id"];
		}
		$DB->freeResults();

		$DB->execute($module_addModuleKeyword,$kwid,$DB->escape($itemid),$DB->escape($_POST["w".$i]));
	}
}

//add the user group mapping for the widget
if (__GROUP_RESTRICTION_ON_SINGLE_WIDGET) {
    $DB->execute($module_deleteUserGroupMapping,$DB->escape($itemid));
    $j = 0;
    $groupList = "";
    while( (isset($_POST['group'.$j])) && (!empty($_POST["group".$j])) ) {
        $group = $_POST['group'.$j];
        $groupList .= $group.",";
        $DB->execute($module_setUserGroupMapping,$DB->escape($itemid),$DB->escape($group));
        $j++;
    }
    if ($groupList!="") {
        $groupList = substr($groupList,0,strlen($groupList)-1);
        $DB->execute($dir_item_setUserGroupMapping,$DB->quote($groupList),$DB->escape($itemid));
    }
    else {
        $DB->execute($dir_item_setUserGroupMapping,$DB->quote(0),$DB->escape($itemid));
    }
}

$defaultIcon = "../modules/pictures/_deficon10.gif";
$urlIconBox = "../modules/pictures/box0_";
$urlPicture = "../modules/pictures/";
if( $icon != $urlIconBox.$itemid && $icon!=$defaultIcon ) {
	$extensionlogo = strrchr($icon,'.');
	if( strlen($extensionlogo)>5 )
		$extensionlogo = "";
	if ( $icon != $urlIconBox.$itemid.$extensionlogo )
	{
		if( copy($urlPicture.$icon,$urlIconBox.$itemid.$extensionlogo) ) {
			//update icon widget
			$DB->execute($scr_moduleUpdateIcon,$DB->quote($urlIconBox.$itemid.$extensionlogo),$DB->escape($itemid));
		}
	}
}
refresh_item($itemid,$template_folder,$__AVLANGS);
foreach ($catId AS $catIdElement)
{
	refresh_directory($catIdElement,$template_folder,"");
}

// category changes
foreach ($oldCatId AS $oldCatIdElement)
{
	if (!in_array($oldCatIdElement,$catId))
	{
		refresh_directory($oldCatIdElement,$template_folder,"");
	}
}

//update the XML file of categories menu
$allCatId = array_unique($allCatId);
$allPagesCat = array();
$script_file=$template_folder."xml_cache_directory.php";
$pagesIdList = array();
foreach($allCatId as $seldir) {
	$DB->getResults($module_getPagesIdByWidgetCat,$DB->escape($seldir));
	while($row = $DB->fetch(0)){
		$pagesIdList[] = $row['page_id'];
	}
	$DB->freeResults();
}

foreach($pagesIdList as $pageId) {
	$DB->getResults($module_getAllWidgetCatForPage,$DB->escape($pageId));//,$DB->escape($seldir));
	while($row = $DB->fetch(0)){
		$allPagesCat[$pageId] = $row['dir_id'];
	}
	$DB->freeResults();
	$cache_file="../cache/cat_".$pageId.".xml";
	cacheDataInFile($script_file, $cache_file, $__AVLANGS, $allPagesCat[$pageId]);
}
$file=new xmlFile();
$file->header("module");
$file->status(1);
$file->footer();
?>