<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# POSH get tags list
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

$folder="";
$not_access=1;
$granted="A";
$pagename="admin/xml_managetags.php";
$isScript=true;
$isPortal=false;

//includes
require_once('includes.php');
require_once('../includes/tags_tools.inc.php');
require_once('../db_layer/'.__DBTYPE.'/admin.php');
require_once('../includes/xml.inc.php');
require_once('../includes/misc.inc.php');
require_once('../includes/log.inc.php');

$action = (isset($_GET["action"])) ? $_GET["action"] : exit();
$tagname = (isset($_GET["tagname"])) ? $_GET["tagname"] : '';
$tagname = strtolower(trim(suppress_accent($tagname)));
$tagid = (isset($_GET["tagid"])) ? $_GET["tagid"] : 0;

//control that the current administrator has access to the script
$grantedCalls = array("configstab");
require('adm_ctrl_access.php');

$file=new xmlFile();

$file->header("tags");

$tagObj = new poshtags($DB);
$datas = $tagObj->initTagTab();
$log=new log();
	
switch ($action) {
    case 'add':
        $str = $tagObj->addTag ($tagname,$datas);
		if( !empty($str) ) {
			$log->addLog($DB,'Keyword adding ('.$tagname.')');
		}
        echo $str;
        break;
    case 'update':
        $str = $tagObj->updateTag ($tagid,$tagname,$datas);
		if( !empty($str) ) {
			$log->addLog($DB,'Keyword modification ('.$tagname.')');
		}
        echo $str;
        break;
    case 'delete':
        $str = $tagObj->deleteTag ($tagid);
		if( !empty($str) ) {
			$log->addLog($DB,'Keyword suppression ('.$tagname.')');
		}
        echo $str;
        break;
}

$file->footer("tags");

?>