<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Archive an article (XML return)
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : 
# ***************************************

require_once("includes_api.php");
require_once("authentication.php");
require_once('../includes/refreshcache.inc.php');

$type = isset($_GET['type']) ? $_GET['type'] : 'I';
$icon = isset($_GET["icon"])?"../modules/pictures/_deficon".$_GET["icon"].".gif":"../modules/pictures/_deficon42.gif";
$tag = isset($_GET["tag"])?$_GET["tag"]:"";
$w_cat = isset($_GET["w_cat"])?$_GET["w_cat"]:1;
$title = isset($_GET["title"])?$_GET["title"]:"";
$status = isset($_GET["status"])?$_GET["status"]:"O";
$w_display= isset($_GET["w_display"])?$_GET["w_display"]:"";
$defvar = "";
$description = "";
$item_id = 0;

// Get language of category
$DB->getResults($module_getDirectoryType,$DB->escape($w_cat));
$row = $DB->fetch(0);
$__AVLANGS[0] = $row["lang"];
$DB->freeResults();

if ($status == 'O') {
    if ($type == 'R') {
        $rss = isset($_GET["rss"])?$_GET["rss"] : exit();
        $rss = urldecode($rss);
        $url = "../modules/p_rss.php?";
        $website = $url;
        $toUpdate = false;

        $DB->getResults($api_checkurl,$DB->quote($rss));
        if ($DB->nbResults() == 0) {
            $DB->execute($api_insertDirRss,$DB->quote($rss),$DB->quote($title),$DB->quote($icon));
            $id = $DB->getId();
            $defvar = "ptitl=".$title."&pdisplay=".$w_display."&nb=5&pfid=".$id."&rssurl=".urlencode($rss);
        }
        else {
            $toUpdate = true;
            $row = $DB->fetch(0);
            $id = $row['id'];
            $DB->freeResults();    
            
            $vars = "pfid=".$id."&rssurl=".urlencode($rss);           
            $defvar = "ptitl=".$title."&pdisplay=".$w_display."&nb=5&pfid=".$id."&rssurl=".urlencode($rss);
            
            $DB->getResults($api_checkdefvar,$DB->quote("%".$vars."%"));
            if ($DB->nbResults() != 0) {
                $row = $DB->fetch(0);
                $item_id = $row['id'];     
                $DB->execute($api_updateStatusDirItem,$DB->quote('O'),$DB->quote("%".urlencode($rss)."%"));
                $DB->execute($api_updateDirItem,$DB->quote($title),$DB->quote('O'),$DB->quote($icon),$DB->quote($defvar),$DB->escape($item_id));
				
		        // update keyword
				$DB->execute($api_deleteTagInSearch_keywords,$DB->escape($item_id));
		        $tag = explode( ","  , $tag );
		        foreach ( $tag as $v_tag ) {
		            $DB->execute($api_addValidationKeyword,$DB->quote($v_tag),$DB->quote($v_tag));
		            $kw_id = $DB->getId();
		            $DB->execute($api_addValidationModuleKeyword,$DB->escape($kw_id),$DB->escape($item_id),2);
		        }
                $DB->freeResults(); 
            }
        }
    }
    else {
        $defvar = "";
        $url = isset($_GET["url"])?$_GET["url"] : exit();
        $website = explode("/",$url);
        $website = "http://".$website[0];
        $toUpdate = false;
        $DB->getResults($api_checkitemurl,$DB->quote($url));
        if ($DB->nbResults() != 0) {
            $toUpdate = true;   
            $row = $DB->fetch(0);
            $item_id = $row['id'];
            $DB->freeResults();
            $DB->execute($api_updateStatusDirItemArticle,$DB->quote('O'),$DB->quote($url));            
            $DB->execute($api_updateDirItem,$DB->quote($title),$DB->quote('O'),$DB->quote($icon),$DB->quote($defvar),$DB->escape($item_id));
			
		    // update keyword
			$DB->execute($api_deleteTagInSearch_keywords,$DB->escape($item_id));
		    $tag = explode( ","  , $tag );
		    foreach ( $tag as $v_tag ) {
				$DB->execute($api_addValidationKeyword,$DB->quote($v_tag),$DB->quote($v_tag));
		        $kw_id = $DB->getId();
		        $DB->execute($api_addValidationModuleKeyword,$DB->escape($kw_id),$DB->escape($item_id),2);
		    }
        }                                                
    }

    if (!$toUpdate) {
        $DB->execute($api_insertDirItem,
                    $DB->quote($url),
                    $DB->quote($defvar),
                    $DB->quote($title),
                    $DB->quote($description),
                    $DB->quote('O'),
                    $DB->quote("O"),
                    $DB->quote($type),
                    246,
                    280,
                    $DB->quote("1"),
                    $DB->quote($website),
                    1,
                    1,
                    $DB->quote("Y"),
                    0,
                    $DB->quote($__AVLANGS[0]),
                    1,
                    0,
                    $DB->quote($icon)
                    );
        $item_id = $DB->getId();
        // insert in category
        $DB->execute($api_insertInCategory,$DB->escape($item_id),$DB->escape($w_cat),$DB->quote("Y"));

        // insert keyword
        $tag = explode( ","  , $tag );
        foreach ( $tag as $v_tag ) {
            $DB->execute($api_addValidationKeyword,$DB->quote($v_tag),$DB->quote($v_tag));
            $kw_id = $DB->getId();
            $DB->execute($api_addValidationModuleKeyword,$DB->escape($kw_id),$DB->escape($item_id),2);
        }
    }
}
elseif($status == "S")
{
    $url = isset($_GET["url"])?$_GET["url"] : '';
    if ($type=="R") {
        $DB->execute($api_updateStatusDirItem,$DB->quote($status),$DB->quote("%".urlencode($url)."%"));
    }
    else {
        $DB->execute($api_updateStatusDirItemArticle,$DB->quote($status),$DB->quote($url));
    }
}
else
{
	// get item id
    if ($type == 'R')
    {
        $rss = isset($_GET["rss"])?$_GET["rss"] : exit();
        $rss = urldecode($rss);
        $DB->getResults($api_getItemRssId,$DB->quote("%".urlencode($rss)."%"));
    }
    else
    {
        $url = isset($_GET["url"])?$_GET["url"] : exit();
        $DB->getResults($api_getItemIframeId,$DB->quote($url));
    }
	$row = $DB->fetch(0);
	$item_id = $row['id'];
    $DB->freeResults();

    $DB->execute($api_updateDirItem,$DB->quote($title),$DB->quote($status),$DB->quote($icon),$DB->quote($defvar),$DB->escape($item_id));

	// update portaneo category
    $DB->execute($api_updateInCategory,$DB->escape($w_cat),$DB->escape($item_id));
	// insert keyword
	$tag = explode( ","  , $tag );
	$DB->getResults($api_getKeyword,$DB->escape($item_id));
	while( $w_tag = $DB->fetch(0) ) {
		$tabTagInDB[] = $w_tag["label"];
	}
	foreach ( $tag as $v_tag ) {
		if(! in_array($v_tag, $tabTagInDB) ) {
		    $DB->execute($api_addValidationKeyword,$DB->quote($v_tag),$DB->quote($v_tag));
		    $kw_id = $DB->getId();
		    $DB->execute($api_addValidationModuleKeyword,$DB->escape($kw_id),$DB->escape($item_id),2);
		}
	}
    $DB->freeResults();
	
}
 
//refresh the cache
refresh_item($item_id,$template_folder,$__AVLANGS);
refresh_directory($w_cat,$template_folder,$__AVLANGS[0]);
?>