<?php
function isMobile()
{

	$userAgent=strtolower($_SERVER['HTTP_USER_AGENT']);

	if(checkUserAgents($userAgent) || checkUserAgentParts($userAgent) || checkServerVariables())
	{
		return true;
	}
	return false;
}
function checkUserAgents($userAgent)
{
	$mobileUserAgents=array('acs-','alav','alca','amoi','audi','aste','avan','benq','bird','blac','blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno','ipaq','ipho','ipod','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-','maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-','newt','noki','opwv','palm','pana','pant','pdxg','phil','play','pluc','port','prox','qtek','qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar','sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-','tosh','treo','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp','wapr','webc','winw','winw','xda-');

	if (in_array(substr($userAgent,0,4),$mobileUserAgents))
	{
		return true;
	}
	return false;
}
function checkUserAgentParts($userAgent)
{
	$checkedElements=array('iemobile','midp','mini','mobile','mmp','pda','phone','pocket','psp','symbian','up.browser','up.link','windows ce');
	foreach($checkedElements AS $checkedElement)
	{
		if (strpos($userAgent,$checkedElement)!==false)
		{
			return true;
		}
	}
	return false;
}
function checkServerVariables()
{
	if (isset($_SERVER['HTTP_PROFILE']) || isset($_SERVER['X-OperaMini-Features']) || isset($_SERVER['UA-pixels']))
	{
		return true;
	}
	return false;
}

// detect and redirect mobile browsers
if(isMobile() || isset($_GET['mob']))
{
    if (isset($_SESSION['user_id'])) {
        session_destroy();
        header('Location: ../includes/plugins/mobile/scripts/login.php');
        exit;
    }  
    header('Location: ../includes/plugins/mobile/scripts/');
    exit;
}
?>
