<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.
*/
# ***************************************
# misc function
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

/*
 *  check if the picture exists
 *  Input :
 *	$pic (str) : picture
 * Output :
 *	$str(str) - picture path or default picture is not exist
 */
function displayPicture($pic)
{
	if (empty($pic))
	{
		$pic='../images/bigicon_network.gif';
		return $pic;
	}
	else
	{
		return $pic;
	}
}	
/*
 *  htmlspecialchardecode which works with php4
 *  Input :
 *	$text (str) : string
 * Output :
 *	$str(str) - encoded string
 */
function decodehtmlchar($text)
{
	return strtr($text, array_flip(get_html_translation_table(HTML_SPECIALCHARS)));
} 
/*
 *  Parser variables which is between $pattern and "&"
 *  Input :
 *	$variables (str) : string
 *	$pattern (str) : string to match
 * Output :
 *	$str(str) - formatted string
 */
function parser($variables,$pattern)
{
	$pattern_long=strlen($pattern);
	$inter=stristr($variables,$pattern);
	$inter2=stristr($inter,'&');
	$long=strlen($inter2);
	if ($long!=0) {
		$res=substr($inter,$pattern_long,-$long);
	}
	else {
		$res=substr($inter,$pattern_long);
	}
	
	return $res;
}
/*
 *  Format tags
 *  Input :
 *	$str (str) : string
 * Output :
 *	$str(str) - formatted string
 */
function php_format_tag($str)
{
	$str=strtolower($str);

	$charset='utf-8';
	$str = htmlentities($str, ENT_NOQUOTES, $charset);
	    
	$str = preg_replace('#\&([A-za-z])(?:uml|circ|tilde|acute|grave|cedil|ring)\;#', '\1', $str);
	$str = preg_replace('#\&([A-za-z]{2})(?:lig)\;#', '\1', $str); 
	$str = preg_replace('#\&[^;]+\;#', '', $str); 
	    
	return $str;
}
/*
 *  Control that the user has access to the mobile version
 *  Input :
 *	$id (int) : user id
 * Output :
 *	boolean true / false
 */
function user_control_mobile_access($id) {
    global $DB, $login_check_user_access;
    $DB->getResults($login_check_user_access,$DB->escape($id));
    if ($DB->nbResults() == 0) {
        return false;
    }
    $row = $DB->fetch(0);
    $access = $row['access'];
    return (($access==1)    ?   true     :     false);
}
/*
 *  Check out if the user has opened his portal (uniq id of widget != 0)
 *  Input :
 *	$id (int) : user id
 * Output :
 *	formatted username
 */
function user_control_webportal_opened($id) {
    global $DB, $login_check_modules_uniq;
    $DB->getResults($login_check_modules_uniq,$DB->escape($id));
    return ($DB->nbResults()>0    ?   false     :     true);
}
/*
 *  Cut the user name to 30 char if > 30
 *  Input :
 *	str (string) : user name
 *	max (int) : max length allowed
 * Output :
 *	formatted username
 */
function formatString($str,$max) {
    if (strlen($str)>$max) {
        $str = substr($str,0,$max);
    }
    return $str;
}


function buildTabs(&$selectedTab,&$tabs) {
    global $DB, $mobPortal_getTabs;
    $inc = 0;
    $htmlTabs = '';
    $html = '<div id="subheader">
                <div class="options">';
                    
    $DB->getResults($mobPortal_getTabs,$DB->escape($_SESSION['user_id']));
    while ($row=$DB->fetch(0)) {
        $tabId = $row['id'];
        $tabName = formatString($row['name'],10);
        if ($selectedTab == '') {
            $selectedTab=$tabId;
        }
        $tabs[$inc] = array("name" => $tabName, "id" => $tabId);                   
        if ($selectedTab == $tabId){
            $htmlTabs.= '<span class="tab_selected"><a href="portal.php?tab='.$tabId.'&tab_name='.$tabName.'">'.ucfirst($tabName).'</a></span>';
            $selectedTabName = $tabName;
        }
        else {
            $htmlTabs.= '<span class="tab_notselected"><a href="portal.php?tab='.$tabId.'&tab_name='.$tabName.'">'.ucfirst($tabName).'</a></span>';
        }
        $htmlTabs.= '<span class="tab_delimiter">&nbsp;|&nbsp;</span>';
        $inc++;
    }
    $DB->freeResults();
    
    $html .= $htmlTabs.'</div></div>';    
    
    return $html;
}
?>