<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.
*/
# ***************************************
# Disconnect from connected environments (personal page & admin)
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************
$not_access=0;

//includes
require_once('includes_mobile.php');
require_once('../../../../db_layer/'.__DBTYPE.'/portal.php');
require_once('../../../authentification.inc.php');
require_once('../../../plugin.api.php');
if (file_exists('../../../plugins.inc.php'))
include_once('../../../plugins.inc.php');
if (defined('__useLdap') && (__useLdap) ) {
    include_once('../../plugin_ldap/ldap.inc.php');
}

$user="";
$password="";
$id="";
$smartphone = false;
$taberr = Array();

//Authentication for smartphone
if (isset($_REQUEST['smartphone']) && $_REQUEST['smartphone'] == "yes") {
    managerSmartphoneUserAuth();
}
//Authentication for web mobile
else {
    managerWebUserAuth();
}


function managerSmartphoneUserAuth() {
    //logout request
    if(isset($_REQUEST["act"]) AND $_REQUEST["act"]=="logout") {
        user_logout();
        exit();
    }
    if(isset($_REQUEST["name"])) {
        $id=$_REQUEST["name"];
        $password=isset($_REQUEST["pass"])?$_REQUEST["pass"]:"";
        $md5=false;
    }
    if (user_login($id,$password,$md5,$user,$error)){
        //user not avtivated in portaneo administration
        if (!user_control_mobile_access($user->id)) {
            $taberr['err'] = "accessdenied";
            print("[".json_encode($taberr)."]");
            exit();
        }
        //user never opened his portal
        elseif (!user_control_webportal_opened($user->id)) {
            $taberr['err'] = "noPortalExisting";
            print("[".json_encode($taberr)."]");
            exit();
        }
        //ok access granted
        else {
            init_session($user->id,$user->username,$user->type,$user->lang,$user->longname,$user->activity);
            if (isset($_POST["autoim"])) {
                    set_cookie('autoim',$user->id,time()+31536000);
                    set_cookie('autopm',$user->pass,time()+31536000);
            }
            $taberr['id'] = $user->id;
            $taberr['username'] = $user->username;
            $taberr['type'] = $user->type;
            $taberr['lang'] = $user->lang;
            $taberr['longname'] = $user->longname;
            $taberr['activity'] = $user->activity;
            $_SESSION['smartphone'] = 1;
            $taberr['sess_id'] = session_id();
            set_cookie("smartauth_l",$user->id,time()+3600*24,"/");
            set_cookie("smartauth_p",$user->pass,time()+3600*24,"/");
            print("[".json_encode($taberr)."]");
            exit();
        }
    }
    else {
        $taberr['err'] = "noPortalExisting";
        print("[".json_encode($taberr)."]");
    }
}





function managerWebUserAuth() {
    //logout request
    if(isset($_REQUEST["act"]) AND $_REQUEST["act"]=="logout") {
        user_logout();
        exit();
    }
    if(isset($_REQUEST["name"])) {
        $id=$_REQUEST["name"];
        $password=isset($_REQUEST["pass"])?$_REQUEST["pass"]:"";
        $md5=false;
    }
    if (user_login($id,$password,$md5,$user,$error)){
        //user not avtivated in portaneo administration
        if (!user_control_mobile_access($user->id)) {
            header("location:login.php?error=accessdenied");
        }
        //user never opened his portal
        elseif (!user_control_webportal_opened($user->id)) {
            header("location:login.php?error=noPortalExisting");
        }
        //ok access granted
        else {
            init_session($user->id,$user->username,$user->type,$user->lang,$user->longname,$user->activity);
            if (isset($_POST["autoim"])) {
                    set_cookie('autoim',$user->id,time()+31536000);
                    set_cookie('autopm',$user->pass,time()+31536000);
            }
            header("location:index.php");
            exit();
        }
    }
    else {
        header("location:login.php?error=errorconnection");
    }
}
?>