<?php
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/* UTF8 encoding : é ô à ù */
require("header.inc.php");
require("../includes/directories_rights.php");

$checks=true;
$collab_suite = isset($_GET['collab_suite']) ? $_GET['collab_suite'] : '';

$controls = array(
                    'PHP server'   => array (
                                                'function'  => 'checkServer();'
                                            ),
                    'Mysql module'   => array (
                                                'function'  => 'checkMysqlModule();'
                                            ),    
                    'Navigator'   => array (
                                                'function'  => 'checkNavigator();'
                                            ),                   
                    'Directories'   => array (
                                                'function'  => 'checkDirectories();'
                                            ),
                    'PHP Config'   => array (
                                                'function'  => 'checkConf();'
                                            ),
                    'Magic quotes'   => array (
                                                'function'  => 'checkMagicQuotes();'
                                            ),
                    'Safe Mode'   => array (
                                                'function'  => 'checkSafeMode();'
                                            ),                  
                    'Server charset'   => array (
                                                'function'  => 'checkServerCharset();'
                                            )
                );
                                                       
//check1 : PHP server                                        
function checkServer()
{
    global $checks;
    if (version_compare(phpversion(), "4.3", ">=")){
        echo "<tr><td><img src='../images/ico_confirm.gif'></td><td>".lg("phpOk")."</td></tr>";
    } else {
        echo "<tr><td><img src='../images/ico_suppress.gif'></td><td>".lg("phpNok")."</td></tr>";
        $checks=false;
    }
}                          
//check2 : Mysql module
function checkMysqlModule()
{
    global $checks;
    if (function_exists('mysql_connect')){
        echo "<tr><td><img src='../images/ico_confirm.gif'></td><td>".lg("mysqlOk")."</td></tr>";
    } else {
        echo "<tr><td><img src='../images/ico_suppress.gif'></td><td>".lg("mysqlNok")."</td></tr>";
        $checks=false;
    }
}
//ckeck3 : navigator                                      
function checkNavigator()           
{
    echo "<tr><td><img src='../images/ico_info.gif'></td><td>".lg("navigatorNeeds")."</td></tr>";
}
//check4 : directories
function checkDirectories()
{
    global $checks;
    $nonWritablefiles=array();
    $directories = getDirectories();
    foreach($directories as $dirName => $fileArray){
        for($i=0;$i<count($fileArray);$i++) {
            if (!is_writable($fileArray[$i])) {
               // if (!in_array(lg("fileMustBeWritable","<i>".$dirName."</i>"),$nonWritablefiles))
               array_push($nonWritablefiles,lg("fileMustBeWritable","<i>".$fileArray[$i]."</i>"));
            }
        }
    }   
    if (count($nonWritablefiles)>0){
        echo "<tr><td valign='top'><img src='../images/ico_suppress.gif'></td><td>".lg("fileNok")."<br />";
        echo implode("<br />",$nonWritablefiles);
        echo "<br /><br /><a href='http://www.portaneo.net' target=_blank>".lg("howToFile")."</a>";
        echo "</td></tr>";
        $checks=false;
    } else {
        echo "<tr><td><img src='../images/ico_confirm.gif'></td><td>".lg("fileOk")."</td></tr>";
    }
}
//check5 : PHP conf files
function checkConf()
{
    global $checks;
    $invalidConf=array();
    if (ini_get("allow_url_fopen")=="0" OR ini_get("allow_url_fopen")=="Off" OR ini_get('allow_url_fopen')=="") {
        array_push($invalidConf,lg("fopenError"));
    }
    if (ini_get('register_globals')=="On" OR ini_get("register_globals")=="1") {
        array_push($invalidConf,lg("registerGlobalsError"));
    }
    if (count($invalidConf)>0){
        echo "<tr><td valign='top'><img src='../images/ico_suppress.gif'></td><td>".lg("iniNok")."<br />";
        echo implode("<br />",$invalidConf);
        echo "<br /><br /><a href='http://www.portaneo.net' target=_blank>".lg("howToIni")."</a>";
        echo "</td></tr>";
        $checks=false;
    } else {
        echo "<tr><td><img src='../images/ico_confirm.gif'></td><td>".lg("iniOk")."</td></tr>";
    }
}
//check6 : magic quotes
function checkMagicQuotes()
{
    if (get_magic_quotes_gpc()) {
        echo "<tr><td><img src='../images/ico_suppress.gif'></td><td>".lg("MagicQuotesMustnotbeActive")."</td></tr>";
    }   
} 
//check7 : is safe mode ON ?
function checkSafeMode()
{
    if( ini_get('safe_mode') ){
        echo "<tr><td><img src='../images/ico_suppress.gif'></td><td>".lg("safeModeAlert")."</td></tr>";
    }
}
//check8 : Warn the user if the server charset is not utf8
function checkServerCharset()
{   
    if (ini_get("default_charset")!="utf-8" || ini_get("default_charset")!="UTF-8" ) {
        echo "<tr><td><img src='../images/ico_info.gif'></td><td>".lg("warnServerCharset")."</td></tr>";
    }
}

//if (isset($_POST["installtype"])) setStep(1,$_POST["installtype"]);
?>

<div class="bottomhr"><h1><?php echo lg("installation".$I_APPLICATION_TYPE);?></h1></div>
<br />
<h2><?php echo lg("step1Title");?></h2><br />
<form action="step2.php?installtype=<?php echo $_GET["installtype"];?>" method="post">
<table cellpadding=5 cellspacing="0">
<?php
if ($collab_suite == "on") {
    echo '<input type="hidden" name="collab_suite" id="collab_suite" value="on" />';
}

//Controls
foreach($controls as $ctrlname => $ctrlhash)
{
    $checkFunction=$controls[$ctrlname]['function'];
    eval($checkFunction);
}   

?>
</table><br /><br />
<?php
if ($checks){
	echo "<h3>".lg("installationCanStart".$I_APPLICATION_TYPE)."</h3>";
	echo "<br /><div style='text-align: right;padding-right: 30px;'><input class='bigbutton' type='submit' value='".lg("continue")." >>>'></div>";
} else {
	echo "<h3>".lg("installationCannotStart")."</h3>";
	echo "<br /><center><input type='button' value='".lg("restart")."' onclick=\"window.location='step1.php?installtype=".$_GET["installtype"]."';\"></center>";
}
?>
</form>

<?php
require("footer.inc.php");
?>