<?php
/*
Delete user account inactive for too long, the default value is 90 days
the delay can be configured in Admin > Configuration > General settings > Advanced Options
The parameter name is "inactiveAccountsDelay".
If set to 0, the cleaning is not happening.
*/


set_time_limit(1000); // if many feeds, loading can be long

//maintenance processes (run daily)
require_once('includes/config.inc.php');
require_once('includes/connection_'.__DBTYPE.'.inc.php');
require('db_layer/'.__DBTYPE.'/admin.php');

global $DB;
if (empty($DB))
	$DB = new connection(__SERVER,__LOGIN,__PASS,__DB);

//Keep latest article, with a min number of archive
$archiveDelay=21*(60*60*24); //number of day of archive
$archiveDelayFilter=false; // not working currently. DO NOT SET TO true
$archiveNumber=50; //number of articles to archive (if not too recent)
$archiveNumberFilter=true; // be careful : if set to false, no minimal limit for the archive removing process based on the date

//loop on feeds
$rows=$DB->select(FETCH_ARRAY,"SELECT id FROM dir_rss");
foreach ($rows as $row)
{
	//get number of articles
	$DB->getResults("SELECT count(id) FROM feed_articles WHERE feed_id=%u",$DB->escape($row["id"]));
	$row2=$DB->fetch(1);
	$nbArticles=$row2[0];
	if ($archiveNumberFilter)
		$nbToRemove=($nbArticles>$archiveNumber)?$nbArticles-$archiveNumber:0;
	$DB->freeResults();
	
	if ($archiveDelayFilter)
	{
		//Remove oldest articles (min number limit if activated)
		$DB->sql = "DELETE FROM feed_articles WHERE (NOW()-pubdate>".$archiveDelay.") ";
		if ($archiveNumberFilter)
			$DB->sql.= "ORDER BY id ASC LIMIT ".$nbToRemove;
		$DB->execute();
	}
	else if ($archiveNumberFilter)
	{
		//Keep only the first rows
		$DB->execute("DELETE FROM feed_articles WHERE feed_id=%u ORDER BY id ASC LIMIT %u",$row["id"],$nbToRemove);
	}
}

//remove the unused items in feed_articles_read
// log the maintenance end
$check=$DB->execute($logMaintenance);

$oldUsers = array();
$anonymous_delay = (__DELAY_COOKIES_ANONYMOUS_USER * 30);

$DB->getResults("SELECT id,typ FROM users WHERE typ='N' AND lastconnect_date < DATE_ADD( NOW( ) , INTERVAL - %u DAY ) LIMIT 150",$DB->escape($anonymous_delay));
while($row = $DB->fetch(0)) 
{
    $user_id = $row["id"];
    array_push($oldUsers,$user_id);
}

//clean the dir item database
if (__inactiveAccountsDelay!=0) {
    $DB->getResults("SELECT id,typ FROM users WHERE typ='J' AND lastconnect_date < DATE_ADD( NOW( ) , INTERVAL - %u DAY ) LIMIT 150",$DB->escape(__inactiveAccountsDelay));
    while($row = $DB->fetch(0))
    {
        $user_id = $row["id"];
        array_push($oldUsers,$user_id);
    }
}

for ($i=0;$i<count($oldUsers);$i++)
{
    $DB->execute("DELETE FROM users_info WHERE user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE FROM users_group_map WHERE user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE FROM profile WHERE user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE FROM module WHERE user_id=%u",$DB->escape($oldUsers[$i]));  
    $DB->execute("DELETE FROM users WHERE id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE FROM users_notes WHERE user_id=%u",$DB->escape($oldUsers[$i])); 
    $DB->execute("DELETE FROM users_mail WHERE user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE users_tasks,users_tasks_id FROM users_tasks,users_tasks_id WHERE users_tasks.task_id=users_tasks_id.id AND users_tasks_id.user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE users_favorites,users_favorites_id FROM users_favorites,users_favorites_id WHERE users_favorites.id=users_favorites_id.id AND users_favorites_id.user_id=%u",$DB->escape($oldUsers[$i]));
    $DB->execute("DELETE widget_addressbook,widget_addressbook_id FROM widget_addressbook,widget_addressbook_id WHERE widget_addressbook.id=widget_addressbook_id.id AND widget_addressbook_id.user_id=%u",$DB->escape($oldUsers[$i]));
}
  
$DB->close();

?>