<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# User notebook
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************

$folder = "../notebook/";
$not_access = 0;
$pagename = "notebook/xml_articles.php";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../l10n/'.__LANG.'/enterprise.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$id = isset($_GET["id"])?$_GET["id"]:0;
$page = isset($_GET["page"]) ? $_GET["page"] : 0;
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0;
$order = isset($_GET['order'])?$_GET['order']:'';
launch_hook('notebook_header',$pagename);

//get Articles access level
if ($user_id == $id)
{
	$notebookAccessLevel = 1;
}
else
{
	$DB->getResults($xmlnotebookprofile_isInNetwork,$DB->escape($id),$DB->escape($user_id));
	if ($DB->nbResults() == 0)
	{
		$notebookAccessLevel = 3;
	}
	else
	{
		$notebookAccessLevel = 2;
	}
	$DB->freeResults();
}

$search = (isset($_GET["search"]) ? $_GET["search"] : "");

/**
 * \details  take the groups to which belong the reader 
 * */
/*$DB->getResults($xmlgroup_getGroupsUser,$DB->escape($user_id));
$tGroupsUser = array();
while($row=$DB->fetch(0))
{
	$tGroup = array();
	$tGroup["group_id"] = $row["id"];
	$tGroup["name"] = $row["name"];
	array_push($tGroupsUser, $tGroup);
}
$DB->freeResults();
*/

$file = new xmlFile();

$file->header("notebook");

if( $order=='rand' ) {
	
	$maxarticles = isset($_GET['nb'])?$_GET['nb']:2;
	$id = (isset($_GET['id']))?$_GET['id']:$_SESSION['user_id'];
	$DB->getResults($index_getRandomNotebookArticles,$DB->escape($id),$DB->escape($maxarticles));

	while ($row = $DB->fetch(0))
	{
		echo '<article>';
		echo '<id>'.$row["id"].'</id>';
		echo '<userid>'.$row["userid"].'</userid>';
		echo '<long_name>'.$row["long_name"].'</long_name>';
		echo '<type>'.$row["type"].'</type>';
		echo '<title><![CDATA['.$row["title"].']]></title>';
		echo '<description><![CDATA['.$row["description"].']]></description>';
		echo '<trackbacknb>'.$row["trackbacknb"].'</trackbacknb>';
		echo '<commentsnb><![CDATA['.$row["commentsnb"].']]></commentsnb>';
		echo '<tags>'.$row["keywords"].'</tags>';
		echo '</article>';
	}
	
	$file->footer();

	$DB->close();
	exit(0);
} elseif ($search == "")
{
	$DB->getResults($index_getNotebookArticles,
                            $DB->escape($id),
                            $DB->escape($notebookAccessLevel),
                            ($page*10));
}
else
{
	//search by tag or plaintxt
	if ($_GET["type"] == "plaintxt")
	{
		$DB->getResults($index_getNotebookSearchedArticles,
                                $DB->escape($id),
                                $DB->escape($notebookAccessLevel),
                                $DB->quote("%".$search."%"),
                                $DB->quote("%".$search."%"),
                                $DB->escape(($page*10))
                                );
	}
	else
	{
		$DB->getResults($index_getNotebookSearchedArticlesTags,
                            $DB->escape($id),
                            $notebookAccessLevel,
                            $DB->escape($search),
                            ($page*10)
                            );
	}
}



$articles = array();
$inc = 0;

while ($row = $DB->fetch(0))
{
    $articles[$inc] = array();
    $articles[$inc]['id'] = $row["id"];
    $articles[$inc]['type'] = $row["type"];
    $articles[$inc]['title'] = $row["title"];
    $articles[$inc]['description'] = $row["description"];
    $articles[$inc]['long_name'] = $row["long_name"];
    $articles[$inc]['picture'] = $row["picture"];
    $articles[$inc]['status'] = $row["status"];
    $articles[$inc]['pubdate'] = $row["pubdate"];
    $articles[$inc]['owner_id'] = $row["owner_id"];
    $articles[$inc]['linked_id'] = $row["linked_id"];
    $articles[$inc]['trackbacknb'] = $row["trackbacknb"];
    $articles[$inc]['commentsnb'] = $row["commentsnb"];
    $articles[$inc]['keywords'] = $row["keywords"];
    $inc ++;
}
$DB->freeResults();

foreach ($articles AS $article)
{
	echo '
<article>
	<id>'.$article["id"].'</id>
	<type>'.$article["type"].'</type>
	<title><![CDATA['.$article["title"].']]></title>
	<description><![CDATA['.$article["description"].']]></description>
	<longname><![CDATA['.$article["long_name"].']]></longname>
	<picture><![CDATA['.$article["picture"].']]></picture>
	<status>'.$article["status"].'</status>
	<pubdate>'.$article["pubdate"].'</pubdate>
	<ownerid>'.$article["owner_id"].'</ownerid>
	<linkedid>'.$article["linked_id"].'</linkedid>
	<trackbacknb>'.$article["trackbacknb"].'</trackbacknb>
	<commentnb>'.$article["commentsnb"].'</commentnb>
	<tags><![CDATA['.$article["keywords"].']]></tags>';
    
    //get article latest comments
    if ($article["commentsnb"] != 0)
    {
        $DB->getResults($xml_articles_get_comments, $article["id"]);
        while ($row = $DB->fetch(0))
        {
            echo '<comment>
                    <id>' . $row['id'] . '</id>
                    <picture><![CDATA['.$row["picture"].']]></picture>
                    <userid>'.$row["user_id"].'</userid>
                    <longname><![CDATA['.$row["long_name"].']]></longname>
                    <pubdate>'.$row["pubdate"].'</pubdate>
                    <message><![CDATA['.$row["message"].']]></message>
                  </comment>';
        }
        $DB->freeResults();
    }
    echo '</article>';
}

$file->footer();

$DB->close();
?>