<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# User notebook article detail 
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************

$folder="../notebook/";
$not_access=0;
$isScript=false;
$isPortal=false;
$useTabs=false;
$pagename="notebook/xml_articles_detail.php";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../l10n/'.__LANG.'/enterprise.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$artid = $DB->escape($_GET["artid"]);
$user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:0;
$v_type = isset($_GET["type"])?$_GET["type"]:'note';
$group_id = isset($_GET["groupid"])?$_GET["groupid"]:0;

launch_hook('notebook_header',$pagename);

//get article owner
$DB->getResults($detail_getArticleOwner,$DB->escape($artid));
$row = $DB->fetch(0);
$id = $row["owner_id"];
$DB->freeResults();


$file=new xmlFile();
$file->header("article");


//get Articles access level
if ($user_id==$id)
{
	$notebookAccessLevel=1;
}
else
{
	$DB->getResults($xmlnotebookprofile_isInNetwork,$DB->escape($id),$DB->escape($user_id));
	if ($DB->nbResults()==0) {
		$notebookAccessLevel=3;
	}
	else {
		$notebookAccessLevel=2;
	}
	$DB->freeResults();
}

if ($v_type == 'group') {
	// get Group information
	include_once('groupsecurity.inc.php');
	echo '<groupprivate>' . $groupType . '</groupprivate>';
	
    // get article information
    $DB->getResults($detail_getGroupArticleInfo,$DB->escape($artid),$DB->escape($group_id));
}
else {
    // get article information
    $DB->getResults($detail_getArticleInfo,$DB->escape($artid));
}

$row = $DB->fetch(0);
$articleStatus = $row['status'];
$articleType = $row['type'];
$title = $row["title"];
$description = $row["description"];
$long_name = $row["long_name"];
$picture = $row["picture"];
$linked_id = $row["linked_id"];
$owner_id = $row["owner_id"];
$pubdate = $row["pubdate"];
$keywords = $row["keywords"];


if ($articleStatus < $notebookAccessLevel) {
	if( $articleStatus == 2 ) {
		$DB->getResults($detail_checkUserInGroup,$DB->escape($user_id),$DB->escape($artid));
		if ($DB->nbResults()==0) {
			exit('error 1'); 
		}
	} else {
		exit('error 2'); 
	}
}
// get the tab secured code if network shared tab
$shared = '';
if ($articleStatus == 2 && $articleType == 4)
{
	$DB->getResults($getPortalSharedString,$linked_id);
	$row = $DB->fetch(0);
	$shared = $row['shared'];
	$DB->freeResults();
}

echo '
<type>'.$articleType.'</type>
<title><![CDATA['.$title.']]></title>
<description><![CDATA['.$description.']]></description>
<longname><![CDATA['.$long_name.']]></longname>
<picture><![CDATA['.$picture.']]></picture>
<status>'.$articleStatus.'</status>
<linked_id>'.$linked_id.'</linked_id>
<shared><![CDATA['.$shared.']]></shared>
<owner_id>'.$owner_id.'</owner_id>
<pubdate>'.$pubdate.'</pubdate>
<tags><![CDATA['.$keywords.']]></tags>
';

$DB->getResults($detail_getDocuments,$DB->escape($artid));
while ($row=$DB->fetch(0))
{
	echo '
<document>
	<id>'.$row["id"].'</id>
	<title><![CDATA['.$row["title"].']]></title>
	<link><![CDATA['.$row["link"].']]></link>
	<size>'.$row["size"].'</size>
</document>
';
}
$DB->freeResults();

//get the trackbacks
$DB->getResults($detail_getTrackbacks,$DB->escape($artid));
if ($DB->nbResults()!=0)
{
	while ($row=$DB->fetch(0))
	{
		echo '
<trackback>
	<type>note</type>
	<id>'.$row["user_id"].'</id>
	<name><![CDATA['.$row["long_name"].']]></name>
	<picture><![CDATA['.$row["picture"].']]></picture>
</trackback>
';
	}
}
$DB->freeResults();

// Trackbacks on groups
$DB->getResults($detail_getTrackbacksGroup,$DB->escape($artid));
if ($DB->nbResults()!=0)
{
	while ($row=$DB->fetch(0))
	{
	echo '
<trackback>
	<type>group</type>
	<id>'.$row["group_id"].'</id>
	<name><![CDATA['.$row["name"].']]></name>
</trackback>
';
	}
}
$DB->freeResults();

//get the comments
$DB->getResults($detail_getComments,$DB->escape($artid));
while ($row=$DB->fetch(0))
{
	echo '
<comment>
	<id>'.$row["id"].'</id>
	<picture><![CDATA['.$row["picture"].']]></picture>
	<userid>'.$row["user_id"].'</userid>
	<longname><![CDATA['.$row["long_name"].']]></longname>
	<pubdate>'.$row["pubdate"].'</pubdate>
	<message><![CDATA['.$row["message"].']]></message>
</comment>
';
}
$DB->freeResults();

$file->footer();

$DB->close();
?>