<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Change user password 
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************
/**
*
* \brief Change user password
*
* @param  (String) pass1 : new password
* @param  (String) oldpass : old password
*
*   return xml file
*
*  \relatesalso
*   ajax.js
*  $p.app.connection.changePass
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/
$test = 0;
$chk  = 0;
$pass1  = (isset($_POST["pass1"])) ? $_POST["pass1"]
                                   : exit();
$oldpass = (isset($_POST["oldpass"])) ? $_POST["oldpass"]
                                      : exit();
									  
$folder     = "";
$not_access = 1;
$isScript   = true;
$isPortal   = false;
$pagename   = "portal/scr_changepwd.php";
$granted    = "I";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../includes/xml.inc.php');
require_once('../includes/misc.inc.php');

launch_hook('scr_changepwd');

$file = new xmlFile();
//$pass_error = true;

$file->header();
$msg_error = "";
	if (strlen($pass1) < 8 && __CONNECTION_SECURITY_LEVEL>=2 ) {
		$msg_error = "msgSubPassToShort8";
	}elseif( __CONNECTION_SECURITY_LEVEL<2 && strlen($pass1) < 6) {
		$msg_error = "msgSubPassToShort";
	} else {
		// Get user name and long_name
		$DB->getResults($user_getUserNamePass,$DB->escape($_SESSION['user_id']));
		$row = $DB->fetch(0);
		$username = $row['username'];
		$long_name = $row['long_name'];
		
		$msg_error = isMixPassword($pass1);
		if( !empty($msg_error) ) {
			$file->status($chk);
			$file->error("".$msg_error);
			$file->footer();
			exit();
		}
		if ( preg_match('/'.$username.'/',$pass1) && __CONNECTION_SECURITY_LEVEL>=2 ){
			$msg_error = "msgLoginInPass";
			$file->status($chk);
			$file->error("".$msg_error);
			$file->footer();
			exit();
		}
		if ( preg_match('/'.$long_name.'/',$pass1) && __CONNECTION_SECURITY_LEVEL>=2 ){
			$msg_error = "msgNameInPass";
			$file->status($chk);
			$file->error("".$msg_error);
			$file->footer();
			exit();
		}
		$DB->freeResults();
		
		if(__CONNECTION_SECURITY_LEVEL>=3) {
			// Check if password is used
			$DB->getResults($user_getUserOldPass,
							$DB->escape($_SESSION['user_id'])
							);
			while($row = $DB->fetch(0)) {
				if($row['md5pass']==md5($pass1)) {
					$msg_error = "msgErrPasswordUsed";
					$file->status($chk);
					$file->error("".$msg_error);
					$file->footer();
					exit();
				}
			}
			$DB->freeResults();
		}
			// Change password in user information table
			$chk = $DB->execute($scrchangepwd_changePassOnProfil,
								$DB->quote($pass1),
								$DB->escape($_SESSION['user_id']),
								$DB->quote($oldpass));
			$test = $DB->nbAffected();
		$DB->freeResults();

	}
if ($test != 0 )
{
		// Change profiles encoded informations that use the password
		$DB->execute($scrchangepwd_changePortalPass,
						$DB->quote($pass1),
						$DB->escape($_SESSION['user_id']),
						$DB->quote($oldpass));

		$DB->execute($scr_insertPortalPass,
						$DB->escape($_SESSION['user_id']),
						$DB->quote($oldpass));

}
$DB->close();




$file->status($chk);
if(!empty($msg_error)) {
	$file->error("".$msg_error);
}elseif ($test == 0)
{
    $file->error("incorrectPassword");

    
    launch_hook('scr_changepwd_incorrectpwd');
}
else
{
    $file->message("passwordModified");
    
    launch_hook('scr_changepwd_pwdmodified');
}

$file->footer();
?>