<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Create a new user portal
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************
/**
*
* \brief
* Create an empty page :  $p.app.pages.newEmpty 
* Create a new tab with html content in frame : $p.app.pages.newHtmlPage
* Add a new tab based on XML Parameters : $p.app.pages.createFromXml
* Save current page (for non connected users) : $p.app.pages.save
*
* @param  
* (Int) pageid
* (Int) w - width
* (Int) s
* (Int) t
* (Int) nb
* (String) icon
* (Int) n - page name
* (Int) ty -  page type
* (String) p - url
* (String) a - module aligned
* (Int) removable
*
*  return xml file
*
*  \relatesalso
*   ajax.js
*  $p.app.pages.newEmpty 
*  $p.app.pages.newHtmlPage
*  $p.app.pages.createFromXml
*  $p.app.pages.save
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder="";
$pagename="portal/scr_createportal.php";
$not_access=0;
$isScript=true;
$isPortal=false;
//includes
require_once('includes.php');
require_once('../includes/pagegeneration.inc.php');
require_once('../includes/xml.inc.php');

launch_hook('scr_createportal');

$file=new xmlFile();

$file->header();

$chk = 0;
$idUser = 0;
$prof = 0;
$createPage = true;

// manage anonymous account
if (isset($_SESSION['user_id'])) {
	$idUser = $_SESSION['user_id'];
}
else if (isset($_SESSION['temp_id'])) {
	$idUser = $_SESSION['temp_id'];
}

echo '<ret><![CDATA[';

if (isset($_POST["seq"])) {
	$seq = $_POST["seq"];
}
else {
	//Check that the max portal number is not reached ================ TO SUPPRESS ?????? ============
	$DB->getResults($scrcreateportal_getTabs,$DB->escape($idUser));
	$row=$DB->fetch(1);
	$seq=$row[0]+1;
	$DB->freeResults();
}
//register the portal general information
$url="notused";
$pageid=isset($_POST["pageid"])?$_POST["pageid"]:0;
$user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:0;

// Update page data after selected the type
$update = isset($_POST['update'])?$_POST['update']:0;
$replacetabid = isset($_GET['replacetabid'])?$_GET['replacetabid']:0;
if($replacetabid>0) {

}
if($update && isset($_SESSION['user_id'])) {
	$createPage = false;
	$prof = isset($_POST['pid'])?$_POST['pid']:0;
	$typ = isset($_POST['typ'])?$_POST['typ']:1;
	$param = isset($_POST['url'])?$_POST['url']:"";
	$chk = $DB->execute($scrcreateportal_updateNewTab,
					$DB->escape($typ),
					$DB->quote($param),
					$DB->escape(0),
					$DB->escape($_SESSION['user_id']),
					$DB->escape($prof));
}
elseif ($pageid != 0)
{
	//$status = isset($_POST['status'])?$_POST['status']:0;
	if (isset($_POST['modif']) && $_POST['modif'] == 'Y')
	{
		// remove old version of the page
		// remove the widgets
		$DB->execute($scrcreateportal_removeOldWidgetsForPageId,
						$DB->escape($_SESSION['user_id']),
						$DB->escape($pageid));
		// remove the page
		$DB->execute($scrcreateportal_removeOldTabsForPageId,
						$DB->escape($_SESSION['user_id']),
						$DB->escape($pageid));
	}
	else
	{
		// check if the page_id is already existing -> if so, do not create the page
		$DB->getResults($scrcreateportal_checkIfPageIdExisting,
						$DB->escape($user_id),
						$DB->escape($pageid));
		if ($DB->nbResults() != 0)
			$createPage = false;
		$DB->freeResults();
	}
}

if ($createPage)
{
	//page width
	$w = isset($_POST["w"]) ? $_POST["w"] : 3;
	//page stylesheet nb
	$s = isset($_POST["s"]) ? $_POST["s"] : 1;
	$t = isset($_POST["t"]) ? $_POST["t"] : 0;
	$nb = isset($_POST["nb"]) ? $_POST["nb"] : 15;
	// page icon
	$icon = isset($_POST["i"]) ? $_POST["i"] : "";
	// page name
	$n = (isset($_POST["n"]) AND $_POST["n"]!="" AND $_POST["n"]!="nouveau")?$_POST["n"]:"page ".$seq;
	// page type (1: personalizable 2: html page 3:javascript 4:redirection)
	$ty = isset($_POST["ty"]) ? $_POST["ty"] : 1;
	$p = isset($_POST["p"]) ? $_POST["p"] : "";
	$tpl = isset($_POST["tpl"]) ? $_POST["tpl"] : 0;
	// modules aligned
	$a = isset($_POST["a"]) ? $_POST["a"] : "Y";
	$ctrl = isset($_POST["ctrl"]) ? $_POST["ctrl"] : "Y";
	$wbar = isset($_POST["wbar"]) ? $_POST["wbar"] : 1;
	$removable = isset($_POST["removable"]) ? $_POST["removable"] : 1;
	$status = isset($_POST['status'])?$_POST['status']:0;
	// Commented BY EMA > Do not work if I add an empty page in a portal
	//	$DB->getResults($getUserpage,$DB->escape($idUser),$DB->escape($pageid));
	//	if($DB->nbResults()==0)
	//	{
	$old_page_id = isset($_POST['pidold'])?$_POST['pidold']:0;
	if($old_page_id>0) {
		$DB->execute($scrsuppersonal_deleteTab,$DB->escape($_SESSION['user_id']),$old_page_id);
	}
	$DB->execute($scrcreateportal_addTab,   $DB->escape($idUser),
											$DB->quote($n),
											$DB->escape($w),
											$DB->escape($s),
											$DB->quote($url),
											$DB->quote($t),
											$DB->escape($nb),
											$DB->escape($seq),
											$DB->quote($icon),
											$DB->quote($a),
											$DB->quote($ty),
											$DB->quote($p),
											$DB->escape($pageid),
											$DB->escape($removable),
											$DB->quote($ctrl),
											$DB->escape($wbar),
											$DB->escape($tpl),
											$status
											);

	$chk = $DB->nbAffected();
	$prof = $DB->getId();

	//register the modules selected and define their place in the page
	$inc=0;
	while (isset($_POST["id".$inc]) AND !Empty($_POST["id".$inc]))
	{
		//get feed id from the variables
		preg_match('/pfid=(\d+)/',$_POST["var".$inc],$matches);
		$fid=(count($matches)>0)?$matches[1]:0;

		$DB->execute($createportal_addModule,
							$DB->escape($_POST["id".$inc]),
							$DB->quote($idUser),
							$DB->escape($prof),
							$DB->escape($_POST["cell".$inc]),
							$DB->escape($_POST["pos".$inc]),
							$DB->escape($_POST["posj".$inc]),
							$DB->escape($_POST["x".$inc]),
							$DB->escape($_POST["y".$inc]),
							$DB->quote($_POST["var".$inc]),
							($inc+1),
							$DB->escape($_POST["blocked".$inc]),
							$DB->escape($_POST["minimized".$inc]),
							$fid);
		$inc++;
	}
}
	
echo $prof . ']]></ret>';

$file->status($chk);

$file->footer();

$DB->close();
$type = isset($_SESSION['type'])?$_SESSION['type']:'';
if($type!='N' && __SAVE_ANONYMOUS_PORTAL) {
	set_cookie('idanonym', '');
	set_cookie('md5anonym', '');
}

?>