<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Add a user in my network
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************

require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../l10n/'.__LANG.'/enterprise.php');
require_once('../includes/xml.inc.php');
require_once('../includes/mail.inc.php');

$file=new xmlFile();

$file->header();

$id = isset($_POST["id"]) ? $_POST["id"] : 0;
$act = isset($_POST["act"]) ? $_POST["act"] : "";

if ($act == 'add' || $act == 'upd')
{
	$desc = isset($_POST["desc"]) ? $_POST["desc"] : "";
	$kw = isset($_POST["kw"]) ? $_POST["kw"] : "";
	$status = isset($_POST["status"]) ? $_POST["status"] : "";
	$kwformated = isset($_POST["kwformated"]) ? $_POST["kwformated"] : "";
	if ( $act == "add" )
	{
		// get friend Email
		$DB->getResults($get_user_info, $DB->escape($id));
		$row = $DB->fetch(0);
		$friendEmail = $row['email'];
		$friendName = $row['long_name'];
		$DB->freeResults();
		
		// create link and send email
		if (__NETWORK_TYPE == 'R')
		{
			//add waiting user link
			$DB->execute($scrnetworkadduser_addUser,
							$DB->escape($_SESSION['user_id']),
							$DB->escape($id),
							$DB->noHTML($desc),
							$DB->quote('W')
			);
			//add invitation
			$DB->execute($scrnetworkadduser_addUser,
							$DB->escape($id),
							$DB->escape($_SESSION['user_id']),
							"''",
							$DB->quote('I')
			);
			
			$notif_subject = lg('notificationNetworkInvitation',$_SESSION['longname'],__APPNAME);
			$notif_message = lg('notificationNetworkInvitationBody',$_SESSION['longname'],__APPNAME,__APPNAME,__LOCALFOLDER);
		}
		else
		{
			//add new user in network
			$DB->execute($scrnetworkadduser_addUser,
							$DB->escape($_SESSION['user_id']),
							$DB->escape($id),
							$DB->noHTML($desc),
							$DB->quote('O')
			);
			
			$notif_subject = lg('notificationFollowing',$_SESSION['longname'],__APPNAME);
			$notif_message = lg('notificationFollowingBody',$_SESSION['longname'],__APPNAME,__APPNAME,__LOCALFOLDER);
		}
		//create an alert about this user adding
		$DB->execute($scrAlertAdd,
						$DB->escape($id),
						'1',
						$DB->escape($_SESSION['user_id']),
						$DB->quote($_SESSION['longname'])
		);
		
		// send email notification / invitation
		$s_mail = new mail();
		$s_mail->addSender(__SUPPORTEMAIL);
		$s_mail->addSubject($notif_subject);
		$s_mail->addMessage($notif_message);
		$s_mail->configArray($friendEmail,'2');
		$s_mail->sendMail();
	}
	else
	{
		//update user information in my network
		$DB->execute($scrnetworkadduser_updateUser,$DB->noHTML($desc),$DB->escape($_SESSION['user_id']),$DB->escape($id));

		$DB->execute($scrnetworkadduser_removeKeywords,$DB->escape($_SESSION['user_id']),$DB->escape($id));
		
		if ($status == 'I')
		{
			$DB->execute($scrnetworkadduser_confirmInvitation,
							$DB->escape($_SESSION['user_id']),
							$DB->escape($id));
			
			$DB->execute($scrnetworkadduser_activateLink,
							$DB->escape($id),
							$DB->escape($_SESSION['user_id']));
		}
	}

	//add keywords linked to user
	if ($_POST["kw"]!="")
	{
		$keyword=explode(",",$kw);
		$keywordSimplified=explode(",",$kwformated);
		for ($i=0;$i<count($keyword);$i++)
		{
			$selkw=$keywordSimplified[$i];
			$DB->getResults($scrnetworkadduser_getKeyword,$DB->noHTML($selkw));
			if ($DB->nbResults()==0)
			{
				$DB->execute($scrnetworkadduser_addNewKeyword,$DB->noHTML($keyword[$i]),$DB->noHTML($selkw));
				$kwid=$DB->getId();
			}
			else
			{
				$row = $DB->fetch(0);
				$kwid=$row["id"];
			}
			$DB->freeResults();

			$DB->execute($scrnetworkadduser_insertKeyword,$DB->escape($_SESSION['user_id']),$DB->escape($id),$kwid);
		}
	}
}
else if ($act == 'accept')
{
	$DB->execute($scrnetworkadduser_confirmInvitation,
					$DB->escape($_SESSION['user_id']),
					$DB->escape($id));
	
	$DB->execute($scrnetworkadduser_activateLink,
					$DB->escape($id),
					$DB->escape($_SESSION['user_id']));
       
    //get friend mail
    /*
    $DB->getResults($get_user_info,$DB->escape($id));
    $row = $DB->fetch(0);
    $friendEmail = $row['email'];
    $DB->freeResults();    
    // send email notification / invitation
    $notif_subject = lg('notificationNetworkAccept',$_SESSION['username']." ".$_SESSION['longname'],__APPNAME);
    $notif_message = lg('notificationNetworkAcceptBody',$_SESSION['username']." ".$_SESSION['longname'],__APPNAME,__LOCALFOLDER);
    $s_mail = new mail();
    $s_mail->addSender(__SUPPORTEMAIL);
    $s_mail->addSubject($notif_subject);
    $s_mail->addMessage($notif_message);
    $s_mail->configArray($friendEmail,'2');
    $s_mail->sendMail(); 
    */
}
else if ($act == 'reject')
{
	$DB->execute($scrnetworkadduser_deleteInvitation,
					$DB->escape($_SESSION['user_id']),
					$DB->escape($id));
	
	$DB->execute($scrnetworkadduser_deleteLink,
					$DB->escape($id),
					$DB->escape($_SESSION['user_id']));
	
	//remove keywords attached to this user
	$DB->execute($scrnetworkremoveuser_removeKeywords,$DB->escape($_SESSION['user_id']),$DB->escape($id));
	$DB->execute($scrnetworkremoveuser_removeKeywords,$DB->escape($id),$DB->escape($_SESSION['user_id']));
}
$DB->close();

$file->status(1);
$file->returnData($id);

$file->footer();
?>