<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Save modules options
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************
/**
*
* \brief Change a module parameter
*
* @param  
* (String)  vars
* (Int) prof
* (Int)  un
*
*  return xml file
*
*  \relatesalso
*   ajax.js
*  $p.app.widgets.changeVar
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder="";
$not_access=1;
$isScript=true;
$isPortal=false;
$pagename="portal/scr_savevar.php";
$granted="I,N";
//includes
require_once('includes.php');
require_once('../includes/xml.inc.php');
require_once('../includes/crypt.php');
launch_hook('scr_savevar');

if (__ENCRYPT_USERPREF) {
	if (!isset($_POST["param"])) exit();
} else {
	if (!isset($_POST["un"])) exit();
	if (!isset($_POST["prof"])) exit();
	if (!isset($_POST["vars"])) exit();
}

$file=new xmlFile();

$file->header();
// init var
$prof = isset($_POST['prof'])?$_POST['prof']:0;
$un = isset($_POST['un'])?$_POST['un']:0;
$vars = "";
$id = isset($_POST['id'])?$_POST['id']:0;
$noteid = isset($_POST['noteid'])?$_POST['noteid']:0;
$taskid = isset($_POST['taskid'])?$_POST['taskid']:0;
$calid = isset($_POST['calid'])?$_POST['calid']:0;
$addid = isset($_POST['addid'])?$_POST['addid']:0;
$linkid = isset($_POST['linkid'])?$_POST['linkid']:0;

$param = isset($_POST["param"])?$_POST["param"]:"";
if (__ENCRYPT_USERPREF) {
	$encryptKey = isset($_SESSION['encrypt_key'])?$_SESSION['encrypt_key']:'';
	$crypt = new crypt();
	$crypt->decryptData($param,$encryptKey);
	$param = $crypt->getDecryptData();

	$t = explode("&",$param);
	foreach ($t as $i => $value) {
		$tmpParam = preg_split('/=/', $t[$i]);
		if($tmpParam[0] == 'prof')	
			$prof = $tmpParam[1];
		if($tmpParam[0] == 'un')	
			$un = $tmpParam[1];
		if($tmpParam[0] == 'vars')	{
				$vars = urldecode(urldecode($tmpParam[1]));
		}
		if($tmpParam[0] == 'id')	
			$id = $tmpParam[1];
		if($tmpParam[0] == 'noteid')	
			$noteid = $tmpParam[1];
		if($tmpParam[0] == 'taskid')	
			$taskid = $tmpParam[1];
		if($tmpParam[0] == 'calid')	
			$calid = $tmpParam[1];
		if($tmpParam[0] == 'addid')	
			$addid = $tmpParam[1];
		if($tmpParam[0] == 'linkid')	
			$linkid = $tmpParam[1];
	}
} else {
	$vars = isset($_POST["vars"])?$_POST["vars"]:"";
}
$module_id = $id;
$sharedkey = "";

$DB->getResults($module_getid,$DB->escape($_SESSION['user_id']),$DB->escape($prof),$DB->escape($un));

$row=$DB->fetch(0);
$item_id = $row['item_id'];
$DB->freeResults();
if( !empty($module_id) && isset($_SESSION['user_id']) ){
	if( isset($noteid)) {
		$noteid = $noteid;
		$DB->getResults($note_getShared,$DB->escape($_SESSION['user_id']),$DB->escape($noteid));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
		$DB->freeResults();
	}
	if( isset($taskid)) {
		$taskid = $taskid;
		$DB->getResults($tasks_getShared,$DB->escape($taskid),$DB->escape($_SESSION['user_id']));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
		$DB->freeResults();
	}
	if( isset($calid)) {
		$calid = $calid;
		$DB->getResults($cal_getShared,$DB->escape($calid),$DB->escape($_SESSION['user_id']));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
		$DB->freeResults();
	}
	if( isset($addid)) {
		$addid = $addid;
		$DB->getResults($addressbook_getShared,$DB->escape($addid),$DB->escape($_SESSION['user_id']));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
		$DB->freeResults();
	}
	if( isset($taskid)) {
		$taskid = $taskid;
		$DB->getResults($tasks_getShared,$DB->escape($taskid),$DB->escape($_SESSION['user_id']));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
		$DB->freeResults();
	}
	if( isset($linkid)) {
		$linkid = $linkid;
		$DB->getResults($links_getShared,$DB->escape($linkid),$DB->escape($_SESSION['user_id']));
		$row=$DB->fetch(0);
		$sharedkey =  $row['shared'];
			$DB->freeResults();
	}
}

if( !empty($sharedkey) ) {
	$vars .= "&sharedkey=".$sharedkey;
}

// save module options changes
$DB->execute($scrsavevar_updateVar,$DB->quote($vars),$DB->escape($_SESSION['user_id']),$DB->escape($prof),$DB->escape($un));

$chk = $DB->nbAffected();
$file->status($chk);

$file->footer();

$DB->close();
?>