<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# restricted modules for a user
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
#
# ***************************************
/**
*
* \brief Load modules directory branches
*
*   return xml file
*
*  \relatesalso
*   ajax.js
*   $p.app.menu.widget.getExplorer
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder="";
$not_access=0;
$granted="I";
$pagename="portal/xmlexplorer.php";
//includes
require_once('includes.php');
require_once('../includes/xml.inc.php');
require_once('../l10n/'.__LANG.'/admin.lang.php');

$user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:0;

/*    
if( !__USE_WIDGET_NOTATION && $user_id==0 ) {
	exit();	
}
*/

$file=new xmlFile();

$file->header("channel");

$dirId = isset($_GET['dirid'])?$_GET['dirid']:0;
$page_id = isset($_GET['pageid'])?$_GET['pageid']:0;
$privateDir = 0;

//get current directory information
$DB->getResults($explorer_getCurrentDirectory, $DB->escape($dirId));
$row = $DB->fetch(0);
$quantityAndSecureQuantity = " (".$row["q"].")";
if(__GROUP_RESTRICTION_ON_SINGLE_WIDGET) {
	$quantityAndSecureQuantity = "";
}
echo "<dirname><![CDATA[".$row["name"]."".$quantityAndSecureQuantity."]]></dirname>";
echo "<parent>".$row["parent_id"]."</parent>";
$privateDir = $row["secured"];
$DB->freeResults();

// get widget path - added by EMA on 01/04/2011
if ($dirId>0)
{
	$curcat = $dirId;
	$curcattext = "";
	$curcatname = "";
	while ($curcat>0)
	{
		$DB->getResults($cache_getDirectoryInformation,$DB->escape($curcat));
		$row = $DB->fetch(0);
		if ($curcat==$dirId)
		{
			$curcatname = $row["name"];
			//$curquantity=$row["quantity"];
			$curcattext = "> " . $curcatname;
			//echo "<parent>".$row["parent_id"]."</parent>";
		}
		else
		{
			$curcattext = "> <a href=# onclick=\"$"."p.app.menu.widget.getExplorer(".$row["id"].",indef,'".$row['lang']."')\" style='color:#000000;text-decoration:underline;'>" . $row["name"] . "</a> " . $curcattext;
		}
		$curcat = $row["parent_id"];
		$DB->freeResults();
	}
	//echo "<dirname><![CDATA[".$curcatname." (".$curquantity.")]]></dirname>";
	echo "<path><![CDATA[ <a href='#' onclick='$"."p.app.menu.widget.getExplorer(0)' style='color:#000000;text-decoration:underline;'>".lg('home')."</a> " . $curcattext . " ]]></path>";
}
else
{
	echo "<path>".lg('home')."</path>";
}

//get subdirectories
if($page_id>0) {
	$DB->getResults($xmldirectory_getChildrenDirectoryXmlBySeqWithPageId, $DB->escape($page_id), $DB->escape($dirId));
    if ($DB->nbResults() == 0) {
        $DB->freeResults();
        $DB->getResults($xmldirectory_getChildrenDirectoryXmlBySeq, $DB->escape($dirId));
    }   
}
if ($page_id == 0) {
    $DB->getResults($xmldirectory_getChildrenDirectoryXmlBySeq, $DB->escape($dirId));
} 

if ($DB->nbResults() > 0)
{
	while ($row = $DB->fetch(0))
	{
		$quantity = $row['quantity'];
		// if(__GROUP_RESTRICTION_ON_SINGLE_WIDGET) {
		// 	$quantity = 0;
		// }
		echo "<dir>";
		echo "<dirid>".$row['id']."</dirid>";
		echo "<dirname><![CDATA[".$row['name']."]]></dirname>";
        echo "<quantity>".$quantity."</quantity>";
        echo "<secured>".$row['secured']."</secured>";
        echo "<secured_quantity>".$row['secured_quantity']."</secured_quantity>";
		echo "</dir>";
	}
}
$DB->freeResults();

if( $privateDir == 1 ) {
	// get secured widgets
	$DB->getResults($xmlexplorer_getPrivateItems,
	                    $DB->escape($dirId),
	                    $DB->escape($_SESSION['user_id']));

	if ($DB->nbResults() > 0)
	{
		while ($row = $DB->fetch(0))
		{
			echo "<item>";
			echo "<id>".$row['id']."</id>";
	        echo "<icon><![CDATA[".$row['icon']."]]></icon>";
	        echo "<secured>1</secured>";
			echo "<name><![CDATA[".$row['name']."]]></name>";
			echo "</item>";
		}
	}

	$DB->freeResults();
} 
else {
	$ratings_enabled = true;

	// get public widgets
	$DB->getResults($xmlexplorer_getPublicItemsAndRatings,
						$DB->escape($user_id),
	                    $DB->escape($dirId)
				   );

	if ($DB->nbResults() > 0 )
	{        
		while ($row = $DB->fetch(0))
		{
			$ratings_enabled = ($row['rating']>0)?false:true;
            $group_access = $row['group_access'];
            //public widgets
            if ($group_access == 0) {
                echo "<item>";
                echo "<id>".$row['id']."</id>";
                echo "<icon><![CDATA[".$row['icon']."]]></icon>";
                echo "<secured>0</secured>";
                echo "<name><![CDATA[".$row['name']."]]></name>";
                echo "<group_access>0</group_access>";
                echo "<average_rating>".(round($row['average_rating']*2)/2)."</average_rating>";
                echo "<total_rating>".$row['total_rating']."</total_rating>";
                echo "<enabled>".$ratings_enabled."</enabled>";
                echo "</item>";
           }
           else {  
                $groups = explode(",", $group_access);
                if (isset($_SESSION['usergroups'])) {
                    for ($i=0;$i<count($groups);$i++) {
                        if (isset($_SESSION['usergroups'][$groups[$i]])) {
                            echo "<item>";
                            echo "<id >".$row['id']."</id>";
                            echo "<icon><![CDATA[".$row['icon']."]]></icon>";
                            echo "<secured>0</secured>";
                            echo "<name><![CDATA[".$row['name']."]]></name>";
                            echo "<group_access><![CDATA[".$group_access."]]></group_access>";
                            echo "<average_rating>".(round($row['average_rating']*2)/2)."</average_rating>";
                            echo "<total_rating>".$row['total_rating']."</total_rating>";
                            echo "<enabled>".$ratings_enabled."</enabled>";
                            echo "</item>";
                            continue;
                        }
                    }
                }            
           }
		}
	}
	$DB->freeResults();
}
$file->footer();

$DB->close();
?>