<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Get users search result
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************
/**
    script : xmlnetwork_search
    
    search users by tags or email
    
    see application.js
    
    Form in application.js 
    
    $p.search.start -> $p.search.network.load
    
    $p.search.network.display -> $p.search.network.load
    
    $p.network.menu.network -> $p.network.add.search
        network menu
        
    Called from 
    $p.network.add.search
    $p.search.network.load
    

    
    @params type            m (default), t (tags)
    
    @params search          string to find
    

**/
$type=isset($_GET["type"])?$_GET["type"]:"m";
$search=(isset($_GET["search"]))?$_GET["search"]:exit();

$folder="";
$not_access=1;
$granted="I";
$pagename="portal/xmlnetwork_search.php";
//includes
require_once('includes.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$file=new xmlFile();

$file->header("results");

$p = isset($_GET["p"])?$_GET["p"]:0;

//search people with email
if ($type=="m")
{
	$DB->getResults($xmlnetworksearch_getUserByName,
                            $DB->quote($search)
                    );
}

//search people with name or tag
if ($type=="t")
{
    $allkeywords = explode(" ", $search);
    $arraywords = array();
    $arraylikewords = array();
    foreach ($allkeywords as $word) {
        array_push($arraywords, $DB->quote($word) );
        array_push($arraylikewords, " sk.label_simplified like '%$word%'");
    }
    $likeliste = ' OR ( ';
    $likeliste .= implode(" OR ", $arraylikewords );
    $likeliste .= ' ) ';    
	$keyword = implode( "," , $arraywords);
    
    
	$DB->getResults($xmlnetworksearch_getUserByKeywords,
                                            $keyword,
                                            $likeliste,
                                            $DB->escape($_SESSION['user_id']),
                                            $DB->escape($p*10)
                                    );
	//if no result with tag, try the name
	if ($DB->nbResults()==0)
	{
		$DB->freeResults();
		$DB->getResults($xmlnetworksearch_getUserByNamePart,
			$DB->quote("%".$search."%"),
			$DB->escape($p*10)
		);
	}
}

if ($type == "s")
{
	$DB->getResults($xmlnetworksearch_getUserByNamePartInMyNetwork,
		$DB->escape($_SESSION['user_id']),
		$DB->quote("%".$search."%"),
		$DB->escape($p*10)
	);
}

while($row=$DB->fetch(0))
{
	echo "<user>";
	echo "<id>".$row["id"]."</id>";
	echo "<longname><![CDATA[".$row["long_name"]."]]></longname>";
	echo "<username><![CDATA[".$row["username"]."]]></username>";
	echo "<email><![CDATA[".$row["email"]."]]></email>";
	echo "<description><![CDATA[".$row["description"]."]]></description>";
	echo "<stat>".$row["stat"]."</stat>";
	echo "<statdate>".$row["statdate"]."</statdate>";
	echo "<activity>".$row["activity"]."</activity>";
	echo "<lastconndate>".$row["lastconnect_date"]."</lastconndate>";
	echo "<dbdate>".$row["dbdate"]."</dbdate>";
	echo "<picture><![CDATA[".$row["picture"]."]]></picture>";
	echo "</user>";
}
$DB->freeResults();

$file->footer("results");

$DB->close();
?>