<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Search in notebooks 
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************

/**
* \brief Search in notebooks 
*
*   script : xmlnotebook_search.php
*   return xml file
*
*  \relatesalso
*   called in application.js from 
*       $p.search.notebook.load ($p.search.notebook.display or $p.search.start)

*
*   @params type 1 search in my articles 2 in all articles
*   @params searchtxt   string to find   
*
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$keywords = isset($_GET["searchtxt"]) ? $_GET["searchtxt"] : exit('error 1');
$page = isset($_GET["p"]) ? $_GET["p"] : exit('error 2');
$type = isset($_GET["type"]) ? $_GET["type"] : 0;
$output = isset($_GET["output"]) ? $_GET["output"] : 'xml';

header("content-type: application/xml"); 

$folder = "";
$not_access = 0;
//$granted = "I";
$pagename = "portal/xmlnotebook_search.php";
//includes
require_once('includes.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

if ($output == 'xml')
{
	$file = new xmlFile();

	$file->header("results");
}
else
{
	echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'>';
	echo '<rss version="2.0" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"><channel>';
}

if ($page < 1000)
{
	//get the modules corresponding to the request based on the indexed keywords
    $allkeywords = explode(" ", $keywords);
    //$arraylikewords = array();
    $arraywords = array();
    $list_keywords ="";
    foreach ($allkeywords as $word) {
        $word = trim($word);
        array_push($arraywords, $DB->quote($word) );
        //array_push($arraylikewords, " label_simplified like '%$word%'");
    }
    $list_keywords .= implode( "," , $arraywords);
    //$likeliste = ' OR ( ';
    //$likeliste .= implode(" OR ", $arraylikewords );
    //$likeliste .= ' ) ';
	if ($type == 1)
	{
        $DB->getResults($xmlnotebooksearch_mynotebooksearch,
                            $list_keywords,
							$DB->quote('%' . $keywords . '%'),
                            //$likeliste,
                            $DB->escape($_SESSION['user_id']),
                            $DB->escape($page*10)
                        );     

	}
    // only in my notebook
	else if ($type == 2)
	{
		$DB->getResults($xmlnotebooksearch_otherNotebookSearch,
                            $list_keywords,
							$DB->quote('%' . $keywords . '%'),
                            //$likeliste,
                            $DB->escape($_SESSION['user_id']),
                            $DB->escape($page*10));
	}
    else
    {
        $DB->getResults($xmlnotebooksearch_allNotebookSearch,
                            $list_keywords,
							$DB->quote('%' . $keywords . '%'),
                            //$likeliste,
                            $DB->escape($_SESSION['user_id']),
                            $DB->escape($_SESSION['user_id']),
                            $DB->escape($page*10));
    }

	$nb_search = $DB->nbResults();
	if ($output == 'xml')
		echo '<nbres>' . $nb_search . '</nbres>';
	else
		echo '<title>' . $keywords . '</title>';

	if ($nb_search > 0)
	{
		while ($row = $DB->fetch(0))
		{
			if ($output == 'xml')
			{
				echo "<item>";
				echo "<id>".$row["id"]."</id>";
				echo "<title><![CDATA[".$row["title"]."]]></title>";
				echo "<date>".$row["pubdate"]."</date>";
				echo "<picture><![CDATA[".$row["picture"]."]]></picture>";
				echo "<owner><![CDATA[".$row["long_name"]."]]></owner>";
				echo "<ownerid>".$row["user_id"]."</ownerid>";
				echo "</item>";
			}
			else
			{
				echo '<item>';
				echo '<title><![CDATA['.$row["title"].']]></title>';
				echo '<link>'.__LOCALFOLDER.'notebook/detail.php?artid='.$row["id"].'</link>';
				echo '<description><![CDATA['.$row["description"].']]></description>';
				echo '<pubDate>'.$row["pubdate"].'</pubDate>';
				echo '</item>';
			}
		}
	}
	$DB->freeResults();
}
if ($output == 'xml')
{
	$file->footer("results");
}
else
{
	echo "</channel></rss>";
}

$DB->close();
?>
