<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Search in lst of widget rss
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************
/**

    xmlsearch.php
    
    see in application.js
    
    checkbox added in function $p.search.init
    
    
    search is started by $p.search.start

**/
$keyword=(isset($_REQUEST["searchtxt"]))?$_REQUEST["searchtxt"]:exit();
$page=(isset($_REQUEST["p"]))?$_REQUEST["p"]:'0';
$searchin=(isset($_REQUEST["searchin"]))?$_REQUEST["searchin"]:'title';
$usedids=(isset($_REQUEST["usedids"]))?$_REQUEST["usedids"]:0;
$output = isset($_GET["output"]) ? $_GET["output"] : 'xml';

header("content-type: application/xml"); 

if(empty($usedids)) {
	$usedids = 0;
}
$usedids .= "0";
$cmdsql = "";
$data = "";
$folder="";
$not_access=0;
$pagename="portal/xmlrss_search.php";
//includes
require_once('includes.php');
require_once('../includes/xml.inc.php');

$limit = 11;
$nb_search = 0;

//control the user rights to see the widget
function controlRigthsToSee($group_access) {
    if ($group_access == 0) {
        return true;
    }
    if ($group_access != 0 && !isset($_SESSION['usergroups'])) {
        return false;
    }    
    $groups = explode(",", $group_access);
    for ($i=0;$i<count($groups);$i++) {
        if (isset($_SESSION['usergroups'][$groups[$i]])) {
            return true;
        }
    }    
    return false;
}

if ($output == 'xml')
{
	$file = new xmlFile();

	$file->header("results");
}
else
{
	echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'>';
	echo '<rss version="2.0" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"><channel>';
}

if (strlen($keyword)<3) {
	echo "<error>1</error>";
}
else {
	//gets each word of the string
	$retItemName = array(); 
	$retItemTag = array();
	//contains the id of the widget found with name match to avoid duplicates with tag match
	$retNameId = array();
	$retNameIdGroup = array();
	$mot = explode(",",$keyword);
	for ($i=0;$i<sizeof($mot);$i++)
	{
		  if (strlen($mot[$i])>=3) {
			  if ($cmdsql=="") {
				  $cmdsql = " title LIKE ".$DB->quote("%".$mot[$i]."%")." ";
			  }
			  else {
				  $cmdsql .= " OR title LIKE ".$DB->quote("%".$mot[$i]."%")." ";	
			  }
		  }
	}	  

	//if total length of the search > 3 but none of the tag's length are > 3 => exit
	if ($cmdsql=="") {
		echo "<error>1</error>";
		$file->footer("results");
		exit(1);
	}
	
	if ($output == 'rss')
		echo '<title>' . $keyword . '</title>';
								
	if ($page<1000)
	{
		//if security is managed at group level
		if (__useGroup)
		{
			$ids = "";
			if( $searchin=='title' ) {
				$page = $page*10;
				$DB->getResults($xmlrss_search,$cmdsql,$usedids,$DB->escape($page),$DB->escape($limit));
				$nb_search = $DB->nbResults();
				
				if ($nb_search>0) {
					while ($row = $DB->fetch(0))
					{
						$ids .= ",".$row["id"];
						$itemid=$row["id"];
						$itemtitle=$row["title"];
						$itemlink=$row["link"];
						$description=html_entity_decode($row["description"]);
						$data .= "<item>";
						$data .= "<id>".$itemid."</id>";
						$data .= "<title><![CDATA[".$itemtitle."]]></title>";
						$data .= "<link><![CDATA[".$itemlink."]]></link>";
						$data .= "<description><![CDATA[".$description."]]></description>";
						$data .= "<pubDate><![CDATA[".$row['pubdate']."]]></pubDate>";
						$data .= "</item>";
					}
					$page = 0;
				}
				$DB->freeResults();
			}
			$usedids = $usedids.$ids;
			if( ( $nb_search>=0 && $nb_search<11) || $searchin=='description') {
				$limit = 11 - $nb_search;
				$cmdsql = preg_replace('/ title LIKE /',' description LIKE ', $cmdsql);
				$DB->getResults($xmlrss_search,$cmdsql,$usedids,$DB->escape($page),$DB->escape($limit));
				$nb_search = $nb_search + $DB->nbResults();

				while ($row = $DB->fetch(0))
				{
					$itemid=$row["id"];
					$itemtitle=$row["title"];
					$itemlink=$row["link"];
					$description=html_entity_decode($row["description"]);
					$data .= "<item>";
					$data .= "<id>".$itemid."</id>";
					$data .= "<title><![CDATA[".$itemtitle."]]></title>";
					$data .= "<link><![CDATA[".$itemlink."]]></link>";
					$data .= "<description><![CDATA[".$description."]]></description>";
					$data .= "<pubDate><![CDATA[".$row['pubdate']."]]></pubDate>";
					$data .= "</item>";
				}
				$DB->freeResults();
				$searchin='description';
			}
			echo "<searchin><![CDATA[".$searchin."]]></searchin>";
			if($limit<11) {
				echo "<page>".$limit."</page>";
			}
			echo $data;
		}
	}
}

if ($output == 'xml')
{
	$file->footer("results");
}
else
{
	echo "</channel></rss>";
}

$DB->close();
?>