<?php
/* 文章管理模块 */
class ArticleAction extends CommonAction {
	//构造函数，调用父类验证登录，并取得文章类型
	function _initialize(){
		parent::_initialize();
		$this->assign('artType',D('Type')->where('ttype=1')->getField('tid,tname'));
	}
	//文章列表、分页
	public function index(){
		if($_REQUEST['keywords']) $where = "atitle like '%".$_REQUEST['keywords']."%'";
		if($_REQUEST['type'] && $_REQUEST['keywords']){
			$where.=' AND atype='.$_REQUEST['type'];
		}elseif($_REQUEST['type']){
			$where = 'atype='.$_REQUEST['type'];
		}
		$Article = D("Article");
		import("ORG.Util.Page");
		$count = $Article->where($where)->count();
		$Page = new Page($count,25);
		
		//分页跳转的时候保证查询条件
		$map = array_filter(array('keywords'=>$_REQUEST['keywords'],'type'=>$_REQUEST['type']));
		foreach($map as $key=>$val) {
			$Page->parameter   .=   "$key=".urlencode($val)."&";			
		}
		$show = $Page->show();
		
		$list = $Article->order('atop DESC,aid DESC')->where($where)->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('artlist',$list); 
	    $this->assign('page',$show);
		$this->assign('title','文章列表');
		$this->display();
	}
	//添加文章，显示添加页面
	public function add(){
		$Article = D('Article');
		if($Article->create()){
			if(!empty($_FILES['aimg']['name'])){
				$upload = $this->upload();
				$Article->aimg = $upload[0]['savename'];
			}
			$Article->adate = date('Y-m-d H:i:s');
			if($Article->add()){
				$this->assign("jumpUrl","__URL__");
				$this->success("添加成功！");
			}else{
				$this->assign("jumpUrl","__URL__");
				$this->error('添加失败！');
			}
		}else{
			$this->fckEditor('acontent');
			$this->display();
		}
	}
	//编辑文章，显示编辑页面
	public function edit(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$data = $_POST;
     		if(!empty($_FILES['aimg']['name'])){
				$upload = $this->upload();
				$data['aimg'] = $upload[0]['savename'];
			}
			if(D('Article')->where('aid='.$data['aid'])->data($data)->save()){
				$this->assign("jumpUrl","__URL__");
				$this->success('修改成功！');
			}else{
				$this->assign("jumpUrl","__URL__");
				$this->error('文章无改变或修改失败！');
			}
		}elseif($_GET['aid']){
			$info = D('Article')->find($_GET['aid']);
			$this->assign('info',$info);
			$this->fckEditor('acontent',$info['acontent']);
			$this->display();
		}
	}
	//删除文章
	public function del(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$map['aid'] = array('in',$_POST['chk']);
			$r = D('Article')->where($map)->delete();
		}elseif($_GET['aid']){
			$r = D('Article')->where('aid='.$_GET['aid'])->delete();
		}
		$r?$this->success('删除成功！'):$this->error('删除失败！');
	}
	//置顶操作
	public function top(){
		$_GET['sign']?$sign=0:$sign=time();
		$r = D('Article')->where('aid='.$_GET['aid'])->setField('atop',$sign);
		$r?$this->success('操作成功！'):$this->error('操作失败！');
	}
	//上传文章缩略图
	public function upload(){
		import("ORG.Net.UploadFile");
		$upload = new UploadFile();
		$upload->maxSize  = 3145728 ; 
		$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg'); 
		$upload->savePath =  './Public/Upload/Article/';
		$upload->saveRule = 'uniqid';
		$upload->thumb = true;
		$upload->thumbMaxWidth = "100";
		$upload->thumbMaxHeight = "100";
		$upload->thumbPrefix = "";

		if(!$upload->upload()) { 
			$this->error($upload->getErrorMsg());
		}else{ 
			return $upload->getUploadFileInfo();
		}
	}
}
?>