<?php
/* 音乐管理模块 */
class MusicAction extends CommonAction {
	//构造函数，调用父类验证登录，并取得分类列表
	function _initialize(){
		parent::_initialize();
		$this->assign('musType',D('Type')->where('ttype=3')->getField('tid,tname'));
	}
	//音乐列表、分页
	public function index(){
		if($_REQUEST['keywords']) $where = "mname like '%".$_REQUEST['keywords']."%'";
		if($_REQUEST['mtype'] && $_REQUEST['keywords']){
			$where.=' AND mtype='.$_REQUEST['type'];
		}elseif($_REQUEST['type']){
			$where = 'mtype='.$_REQUEST['type'];
		}
		$Music = D("Music");
		import("ORG.Util.Page");
		$count = $Music->where($where)->count();
		$Page = new Page($count,16);
		
		//分页跳转的时候保证查询条件
		$map = array_filter(array('keywords'=>$_REQUEST['keywords'],'type'=>$_REQUEST['type']));
		foreach($map as $key=>$val) {
			$Page->parameter   .=   "$key=".urlencode($val)."&";			
		}
		$show = $Page->show();
		
		$list = $Music->order('mtop DESC,mid DESC')->where($where)->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('musiclist',$list); 
	    $this->assign('page',$show);
		$this->assign('title','音乐列表');
		$this->display();
	}
	//添加音乐
	public function add(){
		$Music = D('Music');
		if($Music->create()){
			$Music->mdate = date('Y-m-d');
			$Music->madder = '站长';
			$Music->mverify = 1;
			if($Music->add()){
				$this->assign("jumpUrl","__URL__");
				$this->success("添加成功！");
			}else{
				$this->error('添加失败！');
			}
		}else{
			$this->assign('title','添加音乐');
			$this->display();
		}
	}
	//编辑音乐
	public function edit(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$data = $_POST;
			if(D('Music')->where('mid='.$data['mid'])->data($data)->save()){
				$this->assign("jumpUrl","__URL__");
				$this->success('修改成功！');
			}else{
				$this->assign("jumpUrl","__URL__");
				$this->error('无改变或修改失败！');
			}
		}elseif($_GET['mid']){
			$info = D('Music')->find($_GET['mid']);
			$this->assign('title','编辑音乐');
			$this->assign('info',$info);
			$this->display();
		}
	}
	//删除音乐
	public function del(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$map['mid'] = array('in',$_POST['chk']);
			$r = D('Music')->where($map)->delete();
		}elseif($_GET['mid']){
			$r = D('Music')->where('mid='.$_GET['mid'])->delete();
		}
		$r?$this->success('删除成功！'):$this->error('删除失败！');
	}
	//置顶操作
	public function top(){
		$_GET['sign']?$sign=0:$sign=time();
		$r = D('Music')->where('mid='.$_GET['mid'])->setField('mtop',$sign);
		$r?$this->success('操作成功！'):$this->error('操作失败！');
	}
	//审核操作
	public function audit(){
		$_GET['sign']?$sign=0:$sign=1;
		$r=D('Music')->where('mid='.$_GET['mid'])->setField('mverify',$sign)?$this->success('操作成功！'):$this->error('操作失败！');
	}
}
?>