<?php
/* 主题管理模块 */
class ThemeAction extends CommonAction {
	//主题列表
	public function index(){
		$this->assign('list',D('Theme')->order('tid DESC')->select()); 
		$this->assign('title','主题列表');
		$this->display();
	}
	//添加主题
	public function add(){
		$Theme = D('Theme');
		if($Theme->create()){
			if(!empty($_FILES['timg']['name'])){
				$upload = $this->upload();
				$Theme->timg = $upload[0]['savename'];
			}
			if($Theme->add()){
				$this->assign("jumtimg","__URL__");
				$this->success("添加成功！");
			}else{
				$this->assign("jumtimg","__URL__");
				$this->error('添加失败！');
			}
		}else{
			$this->assign('title','添加主题');
			$this->display();
		}
	}
	//编辑主题
	public function edit(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$data = $_POST;
     		if(!empty($_FILES['timg']['name'])){
				$upload = $this->upload();
				$data['timg'] = $upload[0]['savename'];
			}
			$data['tstate'] = 0;
			if(D('Theme')->where('tid='.$data['tid'])->data($data)->save()){
				$this->assign("jumtimg","__URL__");
				$this->success('修改成功！');
			}else{
				$this->assign("jumtimg","__URL__");
				$this->error('无改变或修改失败！');
			}
		}elseif($_GET['tid']){
			$info = D('Theme')->find($_GET['tid']);
			$this->assign('info',$info);
			$this->assign('title','编辑主题');
			$this->display();
		}
	}
	//删除主题
	public function del(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$map['tid'] = array('in',$_POST['chk']);
			$r = D('Theme')->where($map)->delete();
		}elseif($_GET['tid']){
			$r = D('Theme')->where('tid='.$_GET['tid'])->delete();
		}
		$r?$this->success('删除成功！'):$this->error('删除失败！');
	}
	//采纳操作
	public function adopt(){
		if($_GET['tid']){
			$tdir = D('Theme')->where('tid='.$_GET['tid'])->getField('tdir');
			//写配置文件
			$fp = fopen('./Home/Conf/config.php', 'wb');
			$configfilecontent ='
<?php
$config	=	require "./config.php";
$home_config =  array(
	"DEFAULT_THEME"    => "'.$tdir.'",	// 默认模板主题名称
);
return array_merge($config,$home_config);
?>';
			chmod(__ROOT__.'/Home/Conf/config.php', 0777);
			$result	=	fwrite($fp, trim($configfilecontent));
			@fclose($fp);
			if($result){
				D('Theme')->where('tid='.$_GET['tid'])->setField('tstate',1);
				D('Theme')->where('tid!='.$_GET['tid'])->setField('tstate',0);
				$this->success('操作成功！');
			}else{
				$this->error('操作失败！');
			}
		}
	}
	//上传主题缩略图
	Public function upload(){
		import("ORG.Net.UploadFile");
		$upload = new UploadFile();
		$upload->maxSize  = 3145728 ; 
		$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg'); 
		$upload->savePath =  './Public/Upload/Theme/';
		$upload->saveRule = 'uniqid';
		$upload->thumb = true;
		$upload->thumbMaxWidth = "150";
		$upload->thumbMaxHeight = "120";
		$upload->uploadReplace = true;
		if(!$upload->upload()) { 
			$this->error($upload->getErrorMsg());
		}else{ 
			return $upload->getUploadFileInfo();
		}
	}
}
?>