<?php
/* 视频管理模块 */
class VideoAction extends CommonAction {
	//构造函数，调用父类验证登录，并取得分类列表
	function _initialize(){
		parent::_initialize();
		$this->assign('vidType',D('Type')->where('ttype=4')->getField('tid,tname'));
	}
	//视频列表、分页
	public function index(){
		if($_REQUEST['keywords']) $where = "vname like '%".$_REQUEST['keywords']."%'";
		if($_REQUEST['videotype'] && $_REQUEST['keywords']){
			$where.=' AND vtype='.$_REQUEST['type'];
		}elseif($_REQUEST['type']){
			$where = 'vtype='.$_REQUEST['type'];
		}
		$Video = D("Video");
		import("ORG.Util.Page");
		$count = $Video->where($where)->count();
		$Page = new Page($count,16);
		
		//分页跳转的时候保证查询条件
		$map = array_filter(array('keywords'=>$_REQUEST['keywords'],'type'=>$_REQUEST['type']));
		foreach($map as $key=>$val) {
			$Page->parameter   .=   "$key=".urlencode($val)."&";			
		}
		$show = $Page->show();
		
		$list = $Video->order('vtop DESC,vid DESC')->where($where)->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('vidlist',$list); 
	    $this->assign('page',$show);
		$this->assign('title','视频列表');
		$this->display();
	}
	//添加视频
	public function add(){
		$Video = D('Video');
		if($Video->create()){
			if(!empty($_FILES['vimg']['name'])){
				$upload = $this->upload();
				$Video->vimg = $upload[0]['savename'];
			}
			$Video->videodate = date('Y-m-d');
			$Video->vverify = 1;
			if($Video->add()){
				$this->assign("jumpUrl","__URL__");
				$this->success("添加成功！");
			}else{
				$this->error('添加失败！');
			}
		}else{
			$this->display();
		}
	}
	//编辑视频
	public function edit(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$data = $_POST;
     		if(!empty($_FILES['vimg']['name'])){
				$upload = $this->upload();
				$data['vimg'] = $upload[0]['savename'];
			}
			if(D('Video')->where('vid='.$data['vid'])->data($data)->save()){
				$this->assign("jumpUrl","__URL__");
				$this->success('修改成功！');
			}else{
				$this->error('无改变或修改失败！');
			}
		}elseif($_GET['vid']){
			$info = D('Video')->find($_GET['vid']);
			$this->assign('info',$info);
			$this->display();
		}
	}
	//删除视频
	public function del(){
		if(strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
			$map['vid'] = array('in',$_POST['chk']);
			$r = D('Video')->where($map)->delete();
		}elseif($_GET['vid']){
			$r = D('Video')->where('vid='.$_GET['vid'])->delete();
		}
		$r?$this->success('删除成功！'):$this->error('删除失败！');
	}
	//置顶操作
	public function top(){
		$_GET['sign']?$sign=0:$sign=time();
		$r = D('Video')->where('vid='.$_GET['vid'])->setField('vtop',$sign);
		$r?$this->success('操作成功！'):$this->error('操作失败！');
	}
	//审核操作
	public function audit(){
		$_GET['sign']?$sign=0:$sign=1;
		$r=D('Video')->where('vid='.$_GET['vid'])->setField('vverify',$sign)?$this->success('操作成功！'):$this->error('操作失败！');
	}
	//上传视频缩略图
	Public function upload(){
		import("ORG.Net.UploadFile");
		$upload = new UploadFile();
		$upload->maxSize  = 3145728 ; 
		$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg'); 
		$upload->savePath =  './Public/Upload/Video/';
		$upload->saveRule = 'uniqid';
		$upload->thumb = true;
		$upload->thumbMaxWidth = "128";
		$upload->thumbMaxHeight = "96";
		$upload->thumbPrefix ='';
		$upload->uploadReplace = true;
		if(!$upload->upload()) { 
			$this->error($upload->getErrorMsg());
		}else{ 
			return $upload->getUploadFileInfo();
		}
	}
}
?>